/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.VersionId;
import io.realm.internal.Mediator;
import io.realm.internal.Notifiable;
import io.realm.internal.Observable;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmState;
import io.realm.internal.RealmStateHolder;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.interop.Callback;
import io.realm.internal.interop.Link;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmInterop;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u00052\u00020\u0006:\u00014B5\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016JB\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\n2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0016\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u0015H\u0096\u0002\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020(2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010+0*\"\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00103\u001a\u00020\bH\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00065"}, d2={"Lio/realm/internal/RealmResultsImpl;", "E", "Lio/realm/RealmObject;", "Lkotlin/collections/AbstractList;", "Lio/realm/RealmResults;", "Lio/realm/internal/Observable;", "Lio/realm/internal/RealmStateHolder;", "realm", "Lio/realm/internal/RealmReference;", "nativePointer", "Lio/realm/internal/interop/NativePointer;", "clazz", "Lkotlin/reflect/KClass;", "mediator", "Lio/realm/internal/Mediator;", "mode", "Lio/realm/internal/RealmResultsImpl$Mode;", "(Lio/realm/internal/RealmReference;Lio/realm/internal/interop/NativePointer;Lkotlin/reflect/KClass;Lio/realm/internal/Mediator;Lio/realm/internal/RealmResultsImpl$Mode;)V", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/internal/interop/NativePointer;", "size", "", "getSize", "()I", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "delete", "", "emitFrozenUpdate", "Lkotlinx/coroutines/channels/ChannelResult;", "frozenRealm", "change", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "emitFrozenUpdate-t11v4CI", "freeze", "get", "index", "(I)Lio/realm/RealmObject;", "query", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/internal/RealmResultsImpl;", "realmState", "Lio/realm/internal/RealmState;", "registerForNotification", "callback", "Lio/realm/internal/interop/Callback;", "thaw", "liveRealm", "Mode", "io.realm.kotlin.library"})
public final class RealmResultsImpl<E extends RealmObject>
extends AbstractList<E>
implements RealmResults<E>,
Observable<RealmResultsImpl<E>>,
RealmStateHolder {
    @NotNull
    private final RealmReference realm;
    @NotNull
    private final NativePointer nativePointer;
    @NotNull
    private final KClass<E> clazz;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final Mode mode;

    public RealmResultsImpl(@NotNull RealmReference realm, @NotNull NativePointer nativePointer, @NotNull KClass<E> clazz, @NotNull Mediator mediator, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.realm = realm;
        this.nativePointer = nativePointer;
        this.clazz = clazz;
        this.mediator = mediator;
        this.mode = mode;
    }

    public /* synthetic */ RealmResultsImpl(RealmReference realmReference, NativePointer nativePointer, KClass kClass, Mediator mediator, Mode mode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            mode = Mode.RESULTS;
        }
        this(realmReference, nativePointer, kClass, mediator, mode);
    }

    @NotNull
    public final NativePointer getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    public int getSize() {
        return (int)RealmInterop.INSTANCE.realm_results_count(this.nativePointer);
    }

    @Override
    @NotNull
    public E get(int index) {
        Link link = RealmInterop.INSTANCE.realm_results_get(this.nativePointer, (long)index);
        RealmObjectInternal model = this.mediator.createInstanceOf(this.clazz);
        RealmObjectUtilKt.link(model, this.realm, this.mediator, this.clazz, link);
        return (E)model;
    }

    @Override
    @NotNull
    public RealmResultsImpl<E> query(@NotNull String query2, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            String string = this.clazz.getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            String table = string;
            NativePointer queryPointer = RealmInterop.INSTANCE.realm_query_parse(this.nativePointer, table, query2, Arrays.copyOf(args, args.length));
            NativePointer resultsPointer2 = RealmInterop.INSTANCE.realm_query_find_all(queryPointer);
            return new RealmResultsImpl<E>(this.realm, resultsPointer2, this.clazz, this.mediator, null, 16, null);
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Invalid syntax for query `" + query2 + '`', exception);
        }
    }

    @Override
    @NotNull
    public Flow<RealmResultsImpl<E>> asFlow() {
        RealmReference this_$iv = this.realm;
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return this.realm.getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    public void delete() {
        RealmInterop.INSTANCE.realm_results_delete_all(this.nativePointer);
    }

    @Override
    @NotNull
    public RealmResultsImpl<E> freeze(@NotNull RealmReference frozenRealm) {
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer frozenDbPointer = frozenRealm.getDbPointer();
        NativePointer frozenResults = RealmInterop.INSTANCE.realm_results_resolve_in(this.nativePointer, frozenDbPointer);
        return new RealmResultsImpl<E>(frozenRealm, frozenResults, this.clazz, this.mediator, null, 16, null);
    }

    @Override
    @NotNull
    public RealmResultsImpl<E> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer liveDbPointer = liveRealm.getDbPointer();
        NativePointer liveResultPtr = RealmInterop.INSTANCE.realm_results_resolve_in(this.nativePointer, liveDbPointer);
        return new RealmResultsImpl<E>(liveRealm, liveResultPtr, this.clazz, this.mediator, null, 16, null);
    }

    @Override
    @NotNull
    public NativePointer registerForNotification(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_results_add_notification_callback(this.nativePointer, callback);
    }

    @Override
    @Nullable
    public ChannelResult<Unit> emitFrozenUpdate-t11v4CI(@NotNull RealmReference frozenRealm, @NotNull NativePointer change, @NotNull SendChannel<? super RealmResultsImpl<E>> channel) {
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Notifiable frozenResult = this.freeze(frozenRealm);
        return ChannelResult.box-impl((Object)channel.trySend-JP2dKIU((Object)frozenResult));
    }

    @Override
    @NotNull
    public RealmState realmState() {
        return this.realm;
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/realm/internal/RealmResultsImpl$Mode;", "", "(Ljava/lang/String;I)V", "EMPTY", "RESULTS", "io.realm.kotlin.library"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode EMPTY = new Mode();
        public static final /* enum */ Mode RESULTS = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.EMPTY, Mode.RESULTS};
        }
    }
}

