/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.dynamic;

import io.realm.kotlin.Deleteable;
import io.realm.kotlin.UpdatePolicy;
import io.realm.kotlin.dynamic.DynamicMutableRealm;
import io.realm.kotlin.dynamic.DynamicMutableRealmObject;
import io.realm.kotlin.dynamic.DynamicRealmObject;
import io.realm.kotlin.ext.BaseRealmObjectExtKt;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.InternalDeleteableKt;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.RealmUtilsKt;
import io.realm.kotlin.internal.WriteTransactionManager;
import io.realm.kotlin.internal.interop.LiveRealmT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.query.ObjectQuery;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B-\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J;\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020!2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lio/realm/kotlin/internal/dynamic/DynamicMutableRealmImpl;", "Lio/realm/kotlin/internal/BaseRealmImpl;", "Lio/realm/kotlin/dynamic/DynamicMutableRealm;", "Lio/realm/kotlin/internal/WriteTransactionManager;", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "realm", "Lkotlin/Pair;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/LiveRealmT;", "Lio/realm/kotlin/internal/interop/LiveRealmPointer;", "", "(Lio/realm/kotlin/internal/InternalConfiguration;Lkotlin/Pair;)V", "dbPointer", "(Lio/realm/kotlin/internal/InternalConfiguration;Lio/realm/kotlin/internal/interop/NativePointer;)V", "realmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/kotlin/internal/LiveRealmReference;", "copyToRealm", "Lio/realm/kotlin/dynamic/DynamicMutableRealmObject;", "obj", "Lio/realm/kotlin/dynamic/DynamicRealmObject;", "updatePolicy", "Lio/realm/kotlin/UpdatePolicy;", "delete", "", "deleteable", "Lio/realm/kotlin/Deleteable;", "findLatest", "query", "Lio/realm/kotlin/query/RealmQuery;", "className", "", "args", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "io.realm.kotlin.library"})
public class DynamicMutableRealmImpl
extends BaseRealmImpl
implements DynamicMutableRealm,
WriteTransactionManager {
    @NotNull
    private final LiveRealmReference realmReference;

    public DynamicMutableRealmImpl(@NotNull InternalConfiguration configuration, @NotNull NativePointer<LiveRealmT> dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(dbPointer, (String)"dbPointer");
        super(configuration);
        this.realmReference = new LiveRealmReference(this, dbPointer);
    }

    public DynamicMutableRealmImpl(@NotNull InternalConfiguration configuration, @NotNull Pair<? extends NativePointer<LiveRealmT>, Boolean> realm) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(realm, (String)"realm");
        this(configuration, (NativePointer<LiveRealmT>)((NativePointer)realm.getFirst()));
    }

    @Override
    @NotNull
    public LiveRealmReference getRealmReference() {
        return this.realmReference;
    }

    @Override
    @NotNull
    public RealmQuery<DynamicMutableRealmObject> query(@NotNull String className, @NotNull String query2, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectQuery((RealmReference)this.getRealmReference(), this.getRealmReference().getSchemaMetadata().getOrThrow(className).getClassKey-QNRHIEo(), Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class), this.getConfiguration().getMediator(), null, query2, Arrays.copyOf(args, args.length), null);
    }

    @Override
    @NotNull
    public DynamicMutableRealmObject copyToRealm(@NotNull DynamicRealmObject obj, @NotNull UpdatePolicy updatePolicy) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        return (DynamicMutableRealmObject)RealmUtilsKt.copyToRealm(this.getConfiguration().getMediator(), this.getRealmReference(), (BaseRealmObject)obj, updatePolicy, new LinkedHashMap());
    }

    @Override
    @Nullable
    public DynamicMutableRealmObject findLatest(@NotNull DynamicRealmObject obj) {
        DynamicMutableRealmObject dynamicMutableRealmObject;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!BaseRealmObjectExtKt.isValid(obj)) {
            dynamicMutableRealmObject = null;
        } else {
            DynamicMutableRealmObject dynamicMutableRealmObject2;
            BaseRealmObject $this$runIfManaged$iv = obj;
            boolean $i$f$runIfManaged = false;
            RealmObjectReference<? extends BaseRealmObject> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference($this$runIfManaged$iv);
            if (realmObjectReference == null) {
                dynamicMutableRealmObject2 = null;
            } else {
                RealmObjectReference<? extends BaseRealmObject> $this$findLatest_u24lambda_u2d0 = realmObjectReference;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)$this$findLatest_u24lambda_u2d0.getOwner(), (Object)this.getRealmReference())) {
                    dynamicMutableRealmObject2 = (DynamicMutableRealmObject)obj;
                } else {
                    RealmObjectReference<BaseRealmObject> realmObjectReference2 = $this$findLatest_u24lambda_u2d0.thaw(this.getRealmReference(), (KClass<BaseRealmObject>)Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class));
                    return (DynamicMutableRealmObject)(realmObjectReference2 == null ? null : RealmObjectUtilKt.toRealmObject(realmObjectReference2));
                }
            }
            DynamicMutableRealmObject dynamicMutableRealmObject3 = dynamicMutableRealmObject2;
            if (dynamicMutableRealmObject3 == null) {
                throw new IllegalArgumentException("Cannot lookup unmanaged object");
            }
            dynamicMutableRealmObject = dynamicMutableRealmObject3;
        }
        return dynamicMutableRealmObject;
    }

    @Override
    public void delete(@NotNull Deleteable deleteable) {
        Intrinsics.checkNotNullParameter((Object)deleteable, (String)"deleteable");
        InternalDeleteableKt.asInternalDeleteable(deleteable).delete();
    }

    @Override
    public void beginTransaction() {
        WriteTransactionManager.DefaultImpls.beginTransaction(this);
    }

    @Override
    public boolean isInTransaction() {
        return WriteTransactionManager.DefaultImpls.isInTransaction(this);
    }

    @Override
    public void commitTransaction() {
        WriteTransactionManager.DefaultImpls.commitTransaction(this);
    }

    @Override
    public void cancelWrite() {
        WriteTransactionManager.DefaultImpls.cancelWrite(this);
    }
}

