/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import android.util.Log;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JA\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J9\u0010\u0018\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lio/realm/kotlin/internal/platform/LogCatLogger;", "Lio/realm/kotlin/log/RealmLogger;", "tag", "", "level", "Lio/realm/kotlin/log/LogLevel;", "(Ljava/lang/String;Lio/realm/kotlin/log/LogLevel;)V", "getLevel", "()Lio/realm/kotlin/log/LogLevel;", "getTag", "()Ljava/lang/String;", "formatMessage", "message", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "t", "", "log", "", "throwable", "(Lio/realm/kotlin/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "prepareLogMessage", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "printMessage", "priority", "", "logMessage", "Companion", "io.realm.kotlin.library"})
public final class LogCatLogger
implements RealmLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private final LogLevel level;
    private static final int MAX_TAG_LENGTH = 23;
    private static final int MAX_LOG_LENGTH = 4000;
    private static final int INITIAL_BUFFER_SIZE = 256;

    public LogCatLogger(@NotNull String tag, @NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.tag = tag;
        this.level = level;
    }

    public /* synthetic */ LogCatLogger(String string, LogLevel logLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "REALM";
        }
        this(string, logLevel);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void log(@NotNull LogLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int priority = level.getPriority();
        String logMessage = this.prepareLogMessage(throwable, message, Arrays.copyOf(args, args.length));
        if (logMessage.length() < 4000) {
            this.printMessage(priority, logMessage);
            return;
        }
        int length = logMessage.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = StringsKt.indexOf$default((CharSequence)logMessage, (char)'\n', (int)i, (boolean)false, (int)4, null);
            newline = newline != -1 ? newline : length;
            do {
                String part;
                end = Math.min(newline, i + 4000);
                Intrinsics.checkNotNullExpressionValue((Object)logMessage.substring(i, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.printMessage(priority, part);
            } while ((i = end) < newline);
        }
    }

    private final void printMessage(int priority, String logMessage) {
        if (priority <= LogLevel.TRACE.getPriority()) {
            Log.v((String)this.getTag(), (String)logMessage);
        } else if (priority == LogLevel.DEBUG.getPriority()) {
            Log.d((String)this.getTag(), (String)logMessage);
        } else if (priority == LogLevel.WTF.getPriority()) {
            Log.wtf((String)this.getTag(), (String)logMessage);
        } else {
            Log.println((int)priority, (String)this.getTag(), (String)logMessage);
        }
    }

    private final String prepareLogMessage(Throwable throwable, String message, Object ... args) {
        String messageToLog = message;
        CharSequence charSequence = messageToLog;
        if (charSequence == null || charSequence.length() == 0) {
            if (throwable == null) {
                return "";
            }
            messageToLog = this.getStackTraceString(throwable);
        } else {
            if (!(args.length == 0)) {
                messageToLog = this.formatMessage(messageToLog, Arrays.copyOf(args, args.length));
            }
            if (throwable != null) {
                messageToLog = messageToLog + '\n' + this.getStackTraceString(throwable);
            }
        }
        return messageToLog;
    }

    private final String formatMessage(String message, Object ... args) {
        String string = message;
        Locale locale = Locale.US;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        return string2;
    }

    private final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message) {
        RealmLogger.DefaultImpls.log(this, level, message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lio/realm/kotlin/internal/platform/LogCatLogger$Companion;", "", "()V", "INITIAL_BUFFER_SIZE", "", "MAX_LOG_LENGTH", "MAX_TAG_LENGTH", "getMAX_TAG_LENGTH$annotations", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getMAX_TAG_LENGTH$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

