/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.ObjectBoundRealmResultsKt;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.query.ObjectBoundQuery;
import io.realm.kotlin.notifications.ResultsChange;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001f\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0096\u0001J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010&J\t\u0010'\u001a\u00020\u001aH\u0096\u0001J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0096\u0003J\u0016\u0010*\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010&J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0096\u0001J\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0006\u0010#\u001a\u00020\fH\u0096\u0001J3\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.2\u0006\u0010-\u001a\u00020\u00182\u0016\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010100\"\u0004\u0018\u000101H\u0016\u00a2\u0006\u0002\u00102J\u001f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\fH\u0096\u0001J\t\u00106\u001a\u000207H\u0096\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010*\u0004\b\r\u0010\u000eR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lio/realm/kotlin/internal/ObjectBoundRealmResults;", "E", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/query/RealmResults;", "Lio/realm/kotlin/internal/InternalDeleteable;", "targetObject", "Lio/realm/kotlin/internal/RealmObjectReference;", "realmResults", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/query/RealmResults;)V", "getRealmResults", "()Lio/realm/kotlin/query/RealmResults;", "size", "", "getSize$delegate", "(Lio/realm/kotlin/internal/ObjectBoundRealmResults;)Ljava/lang/Object;", "getSize", "()I", "getTargetObject", "()Lio/realm/kotlin/internal/RealmObjectReference;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/kotlin/notifications/ResultsChange;", "keyPaths", "", "", "contains", "", "element", "(Lio/realm/kotlin/types/BaseRealmObject;)Z", "containsAll", "elements", "", "delete", "", "get", "index", "(I)Lio/realm/kotlin/types/BaseRealmObject;", "indexOf", "(Lio/realm/kotlin/types/BaseRealmObject;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "query", "Lio/realm/kotlin/query/RealmQuery;", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "subList", "fromIndex", "toIndex", "version", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
public final class ObjectBoundRealmResults<E extends BaseRealmObject>
implements RealmResults<E>,
InternalDeleteable {
    @NotNull
    private final RealmObjectReference<?> targetObject;
    @NotNull
    private final RealmResults<E> realmResults;

    public ObjectBoundRealmResults(@NotNull RealmObjectReference<?> targetObject, @NotNull RealmResults<E> realmResults) {
        Intrinsics.checkNotNullParameter(targetObject, (String)"targetObject");
        Intrinsics.checkNotNullParameter(realmResults, (String)"realmResults");
        this.targetObject = targetObject;
        this.realmResults = realmResults;
    }

    @NotNull
    public final RealmObjectReference<?> getTargetObject() {
        return this.targetObject;
    }

    @NotNull
    public final RealmResults<E> getRealmResults() {
        return this.realmResults;
    }

    @Override
    public boolean contains(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.realmResults.containsAll(elements);
    }

    @Override
    public int indexOf(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.realmResults.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.realmResults.iterator();
    }

    @Override
    public int lastIndexOf(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.realmResults.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return this.realmResults.listIterator(index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.realmResults.subList(fromIndex, toIndex);
    }

    @Override
    @NotNull
    public VersionId version() {
        return this.realmResults.version();
    }

    public int getSize() {
        return this.realmResults.size();
    }

    private static Object getSize$delegate(ObjectBoundRealmResults<BaseRealmObject> objectBoundRealmResults) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(objectBoundRealmResults.realmResults, RealmResults.class, "size", "size()I", 0)));
    }

    @Override
    @NotNull
    public E get(int index) {
        return (E)((BaseRealmObject)this.realmResults.get(index));
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String query, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmResults.query(query, Arrays.copyOf(args, args.length)));
    }

    @Override
    @NotNull
    public Flow<ResultsChange<E>> asFlow(@Nullable List<String> keyPaths) {
        return ObjectBoundRealmResultsKt.bind(this.realmResults.asFlow(keyPaths), this.targetObject);
    }

    @Override
    public void delete() {
        if (!(this.realmResults instanceof InternalDeleteable)) {
            throw new IllegalStateException("This class cannot be deleted: " + this + ". It was holding a " + this.realmResults);
        }
        ((InternalDeleteable)((Object)this.realmResults)).delete();
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<E> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super E> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

