/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.exceptions.RealmException;
import io.realm.kotlin.internal.CoreExceptionConverter;
import io.realm.kotlin.internal.interop.CoreErrorConverter;
import io.realm.kotlin.internal.interop.RealmCoreAddressSpaceExhaustedException;
import io.realm.kotlin.internal.interop.RealmCoreCallbackException;
import io.realm.kotlin.internal.interop.RealmCoreColumnAlreadyExistsException;
import io.realm.kotlin.internal.interop.RealmCoreColumnNotFoundException;
import io.realm.kotlin.internal.interop.RealmCoreCrossTableLinkTargetException;
import io.realm.kotlin.internal.interop.RealmCoreDeleteOpenRealmException;
import io.realm.kotlin.internal.interop.RealmCoreDuplicatePrimaryKeyValueException;
import io.realm.kotlin.internal.interop.RealmCoreException;
import io.realm.kotlin.internal.interop.RealmCoreFileAccessErrorException;
import io.realm.kotlin.internal.interop.RealmCoreFilePermissionDeniedException;
import io.realm.kotlin.internal.interop.RealmCoreIllegalOperationException;
import io.realm.kotlin.internal.interop.RealmCoreIndexOutOfBoundsException;
import io.realm.kotlin.internal.interop.RealmCoreInvalidArgumentException;
import io.realm.kotlin.internal.interop.RealmCoreInvalidPathErrorException;
import io.realm.kotlin.internal.interop.RealmCoreInvalidPropertyException;
import io.realm.kotlin.internal.interop.RealmCoreInvalidQueryException;
import io.realm.kotlin.internal.interop.RealmCoreInvalidQueryStringException;
import io.realm.kotlin.internal.interop.RealmCoreInvalidatedObjectException;
import io.realm.kotlin.internal.interop.RealmCoreKeyAlreadyUsedException;
import io.realm.kotlin.internal.interop.RealmCoreKeyNotFoundException;
import io.realm.kotlin.internal.interop.RealmCoreLogicException;
import io.realm.kotlin.internal.interop.RealmCoreMaximumFileSizeExceededException;
import io.realm.kotlin.internal.interop.RealmCoreMissingPrimaryKeyException;
import io.realm.kotlin.internal.interop.RealmCoreMissingPropertyValueException;
import io.realm.kotlin.internal.interop.RealmCoreModifyPrimaryKeyException;
import io.realm.kotlin.internal.interop.RealmCoreMultipleSyncAgentsException;
import io.realm.kotlin.internal.interop.RealmCoreNoSuchObjectException;
import io.realm.kotlin.internal.interop.RealmCoreNoSuchTableException;
import io.realm.kotlin.internal.interop.RealmCoreNoneException;
import io.realm.kotlin.internal.interop.RealmCoreNotClonableException;
import io.realm.kotlin.internal.interop.RealmCoreNotInATransactionException;
import io.realm.kotlin.internal.interop.RealmCoreOtherException;
import io.realm.kotlin.internal.interop.RealmCoreOutOfDiskSpaceException;
import io.realm.kotlin.internal.interop.RealmCoreOutOfMemoryException;
import io.realm.kotlin.internal.interop.RealmCorePropertyNotNullableException;
import io.realm.kotlin.internal.interop.RealmCorePropertyTypeMismatchException;
import io.realm.kotlin.internal.interop.RealmCoreReadOnlyPropertyException;
import io.realm.kotlin.internal.interop.RealmCoreSerializationErrorException;
import io.realm.kotlin.internal.interop.RealmCoreUnexpectedPrimaryKeyException;
import io.realm.kotlin.internal.interop.RealmCoreUnknownException;
import io.realm.kotlin.internal.interop.RealmCoreUnsupportedFileFormatVersionException;
import io.realm.kotlin.internal.interop.RealmCoreWrongPrimaryKeyTypeException;
import io.realm.kotlin.internal.interop.RealmCoreWrongThreadException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\tJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\nH\u0002J\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lio/realm/kotlin/internal/CoreExceptionConverter;", "", "()V", "convertToPublicException", "", "exception", "customMessage", "", "customize", "Lkotlin/Function1;", "Lio/realm/kotlin/internal/interop/RealmCoreException;", "genericRealmCoreExceptionHandler", "message", "cause", "initialize", "", "io.realm.kotlin.library"})
public final class CoreExceptionConverter {
    @NotNull
    public static final CoreExceptionConverter INSTANCE = new CoreExceptionConverter();

    private CoreExceptionConverter() {
    }

    public final void initialize() {
        CoreErrorConverter.INSTANCE.initialize((Function1)initialize.1.INSTANCE);
    }

    @NotNull
    public final Throwable convertToPublicException(@NotNull Throwable exception, @NotNull String customMessage, @Nullable Function1<? super RealmCoreException, ? extends Throwable> customize) {
        Throwable cause;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)customMessage, (String)"customMessage");
        if (exception instanceof RealmException && (cause = exception.getCause()) instanceof RealmCoreException) {
            Throwable publicException;
            Throwable throwable = publicException = customize != null ? (Throwable)customize.invoke((Object)cause) : null;
            if (publicException == null) {
                publicException = this.genericRealmCoreExceptionHandler(customMessage, (RealmCoreException)cause);
            }
            return publicException;
        }
        return exception;
    }

    public static /* synthetic */ Throwable convertToPublicException$default(CoreExceptionConverter coreExceptionConverter, Throwable throwable, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return coreExceptionConverter.convertToPublicException(throwable, string, (Function1<? super RealmCoreException, ? extends Throwable>)function1);
    }

    private final Throwable genericRealmCoreExceptionHandler(String message, RealmCoreException cause) {
        Throwable throwable;
        RealmCoreException realmCoreException = cause;
        if ((((((realmCoreException instanceof RealmCoreOutOfMemoryException ? true : realmCoreException instanceof RealmCoreUnsupportedFileFormatVersionException) ? true : realmCoreException instanceof RealmCoreInvalidPathErrorException) ? true : realmCoreException instanceof RealmCoreMultipleSyncAgentsException) ? true : realmCoreException instanceof RealmCoreAddressSpaceExhaustedException) ? true : realmCoreException instanceof RealmCoreMaximumFileSizeExceededException) ? true : realmCoreException instanceof RealmCoreOutOfDiskSpaceException) {
            throwable = new RealmException(message + ": RealmCoreException(" + cause.getMessage() + ')', (Throwable)cause);
        } else if (realmCoreException instanceof RealmCoreIndexOutOfBoundsException) {
            throwable = new IndexOutOfBoundsException(message + ": RealmCoreException(" + cause.getMessage() + ')');
        } else if (((((((((realmCoreException instanceof RealmCoreInvalidArgumentException ? true : realmCoreException instanceof RealmCoreInvalidQueryStringException) ? true : realmCoreException instanceof RealmCoreOtherException) ? true : realmCoreException instanceof RealmCoreInvalidQueryException) ? true : realmCoreException instanceof RealmCoreMissingPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreUnexpectedPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreWrongPrimaryKeyTypeException) ? true : realmCoreException instanceof RealmCoreModifyPrimaryKeyException) ? true : realmCoreException instanceof RealmCorePropertyNotNullableException) ? true : realmCoreException instanceof RealmCoreDuplicatePrimaryKeyValueException) {
            throwable = new IllegalArgumentException(message + ": RealmCoreException(" + cause.getMessage() + ')', (Throwable)cause);
        } else if ((((realmCoreException instanceof RealmCoreNotInATransactionException ? true : realmCoreException instanceof RealmCoreDeleteOpenRealmException) ? true : realmCoreException instanceof RealmCoreFileAccessErrorException) ? true : realmCoreException instanceof RealmCoreFilePermissionDeniedException) ? true : realmCoreException instanceof RealmCoreLogicException) {
            throwable = new IllegalStateException(message + ": RealmCoreException(" + cause.getMessage() + ')', (Throwable)cause);
        } else if ((((((((((((((((((realmCoreException instanceof RealmCoreNoneException ? true : realmCoreException instanceof RealmCoreUnknownException) ? true : realmCoreException instanceof RealmCoreNotClonableException) ? true : realmCoreException instanceof RealmCoreWrongThreadException) ? true : realmCoreException instanceof RealmCoreInvalidatedObjectException) ? true : realmCoreException instanceof RealmCoreInvalidPropertyException) ? true : realmCoreException instanceof RealmCoreMissingPropertyValueException) ? true : realmCoreException instanceof RealmCorePropertyTypeMismatchException) ? true : realmCoreException instanceof RealmCoreReadOnlyPropertyException) ? true : realmCoreException instanceof RealmCoreNoSuchTableException) ? true : realmCoreException instanceof RealmCoreNoSuchObjectException) ? true : realmCoreException instanceof RealmCoreCrossTableLinkTargetException) ? true : realmCoreException instanceof RealmCoreKeyNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnAlreadyExistsException) ? true : realmCoreException instanceof RealmCoreKeyAlreadyUsedException) ? true : realmCoreException instanceof RealmCoreSerializationErrorException) ? true : realmCoreException instanceof RealmCoreIllegalOperationException) ? true : realmCoreException instanceof RealmCoreCallbackException) {
            throwable = new RealmException(message + ": RealmCoreException(" + cause.getMessage() + ')', (Throwable)cause);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }
}

