/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.RealmUUIDImpl;
import io.realm.kotlin.internal.interop.UUIDWrapper;
import io.realm.kotlin.internal.util.HexadecimalKt;
import io.realm.kotlin.types.RealmUUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u0014\u0010\f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/realm/kotlin/internal/RealmUUIDImpl;", "Lio/realm/kotlin/types/RealmUUID;", "Lio/realm/kotlin/internal/interop/UUIDWrapper;", "wrapper", "(Lio/realm/kotlin/internal/interop/UUIDWrapper;)V", "()V", "uuidString", "", "(Ljava/lang/String;)V", "byteArray", "", "([B)V", "bytes", "getBytes", "()[B", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "io.realm.kotlin.library"})
public final class RealmUUIDImpl
implements RealmUUID,
UUIDWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    private static final int UUID_BYTE_SIZE = 16;
    @NotNull
    private static final Lazy<Regex> UUID_REGEX$delegate = LazyKt.lazy((Function0)Companion.UUID_REGEX.2.INSTANCE);

    @Override
    @NotNull
    public byte[] getBytes() {
        return this.bytes;
    }

    public RealmUUIDImpl(@NotNull UUIDWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this(wrapper.getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public RealmUUIDImpl() {
        void $this$_init__u24lambda_u240;
        byte[] byArray;
        byte[] byArray2 = byArray = Random.Default.nextBytes(16);
        RealmUUIDImpl realmUUIDImpl = this;
        boolean bl = false;
        $this$_init__u24lambda_u240[6] = (byte)($this$_init__u24lambda_u240[6] & 0xF);
        $this$_init__u24lambda_u240[6] = (byte)($this$_init__u24lambda_u240[6] | 0x40);
        $this$_init__u24lambda_u240[8] = (byte)($this$_init__u24lambda_u240[8] & 0x3F);
        $this$_init__u24lambda_u240[8] = (byte)($this$_init__u24lambda_u240[8] | 0xFFFFFF80);
        realmUUIDImpl.bytes = byArray;
    }

    public RealmUUIDImpl(@NotNull String uuidString) {
        Intrinsics.checkNotNullParameter((Object)uuidString, (String)"uuidString");
        this.bytes = RealmUUIDImpl.Companion.parseUUIDString(uuidString);
    }

    public RealmUUIDImpl(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        if (byteArray.length != 16) {
            throw new IllegalArgumentException("Invalid 'bytes' size " + byteArray.length + ", byte array size must be 16");
        }
        this.bytes = byteArray;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        return Arrays.equals(((RealmUUID)other).getBytes(), this.getBytes());
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return HexadecimalKt.toHexString(this.getBytes(), 0, 4) + '-' + HexadecimalKt.toHexString(this.getBytes(), 4, 6) + '-' + HexadecimalKt.toHexString(this.getBytes(), 6, 8) + '-' + HexadecimalKt.toHexString(this.getBytes(), 8, 10) + '-' + HexadecimalKt.toHexString(this.getBytes(), 10, 16);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/realm/kotlin/internal/RealmUUIDImpl$Companion;", "", "()V", "UUID_BYTE_SIZE", "", "UUID_REGEX", "Lkotlin/text/Regex;", "getUUID_REGEX", "()Lkotlin/text/Regex;", "UUID_REGEX$delegate", "Lkotlin/Lazy;", "parseUUIDString", "", "uuidString", "", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        private final Regex getUUID_REGEX() {
            Lazy lazy = UUID_REGEX$delegate;
            return (Regex)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] parseUUIDString(String uuidString) {
            void $this$mapTo$iv$iv;
            MatchResult matchResult = this.getUUID_REGEX().matchEntire((CharSequence)uuidString);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid string representation of an UUID: '" + uuidString + '\'');
            }
            MatchResult matchGroup = matchResult;
            Iterable $this$map$iv = (Iterable)new IntRange(1, 5);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void groupIndex;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MatchGroup matchGroup2 = matchGroup.getGroups().get((int)groupIndex);
                Intrinsics.checkNotNull((Object)matchGroup2);
                collection.add(HexadecimalKt.parseHex(matchGroup2.getValue()));
            }
            List byteGroups = (List)destination$iv$iv;
            return ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])((byte[])byteGroups.get(0)), (byte[])((byte[])byteGroups.get(1))), (byte[])((byte[])byteGroups.get(2))), (byte[])((byte[])byteGroups.get(3))), (byte[])((byte[])byteGroups.get(4)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

