/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.ext.BaseRealmObjectExtKt;
import io.realm.kotlin.internal.ObjectBoundRealmResults;
import io.realm.kotlin.internal.RealmObjectHelper;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmResultsImpl;
import io.realm.kotlin.internal.schema.ClassMetadata;
import io.realm.kotlin.internal.schema.PropertyMetadata;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.types.BacklinksDelegate;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.RealmObject;
import io.realm.kotlin.types.TypedRealmObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0096\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/realm/kotlin/internal/BacklinksDelegateImpl;", "T", "Lio/realm/kotlin/types/TypedRealmObject;", "Lio/realm/kotlin/types/BacklinksDelegate;", "sourceClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "getValue", "Lio/realm/kotlin/query/RealmResults;", "reference", "Lio/realm/kotlin/types/RealmObject;", "targetProperty", "Lkotlin/reflect/KProperty;", "io.realm.kotlin.library"})
public final class BacklinksDelegateImpl<T extends TypedRealmObject>
implements BacklinksDelegate<T> {
    @NotNull
    private final KClass<T> sourceClass;

    public BacklinksDelegateImpl(@NotNull KClass<T> sourceClass) {
        Intrinsics.checkNotNullParameter(sourceClass, (String)"sourceClass");
        this.sourceClass = sourceClass;
    }

    @Override
    @NotNull
    public RealmResults<T> getValue(@NotNull RealmObject reference, @NotNull KProperty<?> targetProperty) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(targetProperty, (String)"targetProperty");
        if (!BaseRealmObjectExtKt.isManaged(reference)) {
            throw new IllegalStateException("Unmanaged objects don't support backlinks.");
        }
        RealmObjectReference<? extends BaseRealmObject> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference(reference);
        Intrinsics.checkNotNull(realmObjectReference);
        RealmObjectReference<? extends BaseRealmObject> objectReference = realmObjectReference;
        PropertyMetadata propertyMetadata = objectReference.getMetadata().get(targetProperty);
        Intrinsics.checkNotNull((Object)propertyMetadata);
        PropertyMetadata targetPropertyMetadata = propertyMetadata;
        ClassMetadata sourceClassMetadata = objectReference.getOwner().getSchemaMetadata().getOrThrow(targetPropertyMetadata.getLinkTarget());
        PropertyMetadata propertyMetadata2 = sourceClassMetadata.get(targetPropertyMetadata.getLinkOriginPropertyName());
        Intrinsics.checkNotNull((Object)propertyMetadata2);
        long sourcePropertyKey = propertyMetadata2.getKey--EmY2nY();
        RealmObjectHelper realmObjectHelper = RealmObjectHelper.INSTANCE;
        long l = sourceClassMetadata.getClassKey-QNRHIEo();
        KClass<T> kClass = this.sourceClass;
        RealmResultsImpl<T> linkingObjects = realmObjectHelper.getBacklinks-JlhGzT4$io_realm_kotlin_library(objectReference, l, sourcePropertyKey, kClass);
        return new ObjectBoundRealmResults(objectReference, linkingObjects);
    }
}

