/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.ObjectIdImpl;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.internal.util.HexadecimalKt;
import io.realm.kotlin.types.ObjectId;
import io.realm.kotlin.types.RealmInstant;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.text.Regex;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fB'\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0006\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0013J\u0011\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/realm/kotlin/internal/ObjectIdImpl;", "Lio/realm/kotlin/types/ObjectId;", "timestamp", "Lio/realm/kotlin/types/RealmInstant;", "(Lio/realm/kotlin/types/RealmInstant;)V", "epochSeconds", "", "(I)V", "hexString", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "counter", "(II)V", "randomValue1", "randomValue2", "", "(IISI)V", "getBytes", "()[B", "compareTo", "other", "equals", "", "o", "", "hashCode", "toByteArray", "toString", "Companion", "io.realm.kotlin.library"})
public final class ObjectIdImpl
implements ObjectId {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    private final int timestamp;
    private final int counter;
    private final int randomValue1;
    private final short randomValue2;
    @Deprecated
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    @Deprecated
    private static final int RANDOM_VALUE1 = Random.Default.nextInt(0x1000000);
    @Deprecated
    private static final short RANDOM_VALUE2 = (short)Random.Default.nextInt(32768);
    @Deprecated
    @NotNull
    private static final AtomicInt NEXT_COUNTER = AtomicFU.atomic((int)Random.Default.nextInt());
    @Deprecated
    @NotNull
    private static final Lazy<Regex> OBJECT_ID_REGEX$delegate = LazyKt.lazy((Function0)Companion.OBJECT_ID_REGEX.2.INSTANCE);

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public ObjectIdImpl(@NotNull RealmInstant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this((int)timestamp.getEpochSeconds(), NEXT_COUNTER.incrementAndGet() & 0xFFFFFF);
    }

    public /* synthetic */ ObjectIdImpl(RealmInstant realmInstant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            realmInstant = RealmInstant.Companion.from(SystemUtilsKt.epochInSeconds(), 0);
        }
        this(realmInstant);
    }

    public ObjectIdImpl(int epochSeconds) {
        this(epochSeconds, NEXT_COUNTER.incrementAndGet() & 0xFFFFFF);
    }

    public ObjectIdImpl(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        this(ObjectIdImpl.Companion.parseObjectIdString(hexString));
    }

    public ObjectIdImpl(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length != 12) {
            throw new IllegalArgumentException("byte array size must be 12");
        }
        this.timestamp = ObjectIdImpl.Companion.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
        this.randomValue1 = ObjectIdImpl.Companion.makeInt((byte)0, bytes[4], bytes[5], bytes[6]);
        this.randomValue2 = ObjectIdImpl.Companion.makeShort(bytes[7], bytes[8]);
        this.counter = ObjectIdImpl.Companion.makeInt((byte)0, bytes[9], bytes[10], bytes[11]);
        this.bytes = bytes;
    }

    private ObjectIdImpl(int timestamp, int counter) {
        this(timestamp, RANDOM_VALUE1, RANDOM_VALUE2, counter);
    }

    private ObjectIdImpl(int timestamp, int randomValue1, short randomValue2, int counter) {
        if ((randomValue1 & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The random value must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if ((counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        this.timestamp = timestamp;
        this.counter = counter & 0xFFFFFF;
        this.randomValue1 = randomValue1;
        this.randomValue2 = randomValue2;
        this.bytes = this.toByteArray();
    }

    private final byte[] toByteArray() {
        byte[] buffer = new byte[]{ObjectIdImpl.Companion.int3(this.timestamp), ObjectIdImpl.Companion.int2(this.timestamp), ObjectIdImpl.Companion.int1(this.timestamp), ObjectIdImpl.Companion.int0(this.timestamp), ObjectIdImpl.Companion.int2(this.randomValue1), ObjectIdImpl.Companion.int1(this.randomValue1), ObjectIdImpl.Companion.int0(this.randomValue1), ObjectIdImpl.Companion.short1(this.randomValue2), ObjectIdImpl.Companion.short0(this.randomValue2), ObjectIdImpl.Companion.int2(this.counter), ObjectIdImpl.Companion.int1(this.counter), ObjectIdImpl.Companion.int0(this.counter)};
        return buffer;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(o.getClass()))) {
            return false;
        }
        ObjectIdImpl objectId = (ObjectIdImpl)o;
        if (this.counter != objectId.counter) {
            return false;
        }
        if (this.timestamp != objectId.timestamp) {
            return false;
        }
        if (this.randomValue1 != objectId.randomValue1) {
            return false;
        }
        return this.randomValue2 == objectId.randomValue2;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.counter;
        result = 31 * result + this.randomValue1;
        result = 31 * result + this.randomValue2;
        return result;
    }

    @Override
    public int compareTo(@NotNull ObjectId other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (int i = 0; i < 12; ++i) {
            if (this.bytes[i] == ((ObjectIdImpl)other).bytes[i]) continue;
            return this.bytes[i] < ((ObjectIdImpl)other).bytes[i] ? -1 : 1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return HexadecimalKt.toHexString$default(this.bytes, 0, 0, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J(\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/realm/kotlin/internal/ObjectIdImpl$Companion;", "", "()V", "LOW_ORDER_THREE_BYTES", "", "NEXT_COUNTER", "Lkotlinx/atomicfu/AtomicInt;", "OBJECT_ID_REGEX", "Lkotlin/text/Regex;", "getOBJECT_ID_REGEX", "()Lkotlin/text/Regex;", "OBJECT_ID_REGEX$delegate", "Lkotlin/Lazy;", "RANDOM_VALUE1", "RANDOM_VALUE2", "", "int0", "", "x", "int1", "int2", "int3", "makeInt", "b3", "b2", "b1", "b0", "makeShort", "parseObjectIdString", "", "hexString", "", "short0", "short1", "io.realm.kotlin.library"})
    private static final class Companion {
        private Companion() {
        }

        private final Regex getOBJECT_ID_REGEX() {
            Lazy lazy = OBJECT_ID_REGEX$delegate;
            return (Regex)lazy.getValue();
        }

        private final byte[] parseObjectIdString(String hexString) {
            if (!this.getOBJECT_ID_REGEX().matches((CharSequence)hexString)) {
                throw new IllegalArgumentException("invalid hexadecimal representation of an ObjectId: [" + hexString + ']');
            }
            return HexadecimalKt.parseHex(hexString);
        }

        private final int makeInt(byte b3, byte b2, byte b1, byte b0) {
            return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
        }

        private final short makeShort(byte b1, byte b0) {
            return (short)((b1 & 0xFF) << 8 | b0 & 0xFF);
        }

        private final byte int3(int x) {
            return (byte)(x >> 24);
        }

        private final byte int2(int x) {
            return (byte)(x >> 16);
        }

        private final byte int1(int x) {
            return (byte)(x >> 8);
        }

        private final byte int0(int x) {
            return (byte)x;
        }

        private final byte short1(short x) {
            return (byte)(x >> 8);
        }

        private final byte short0(short x) {
            return (byte)x;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

