/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.FrozenRealmReference;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.LiveRealmReference;
import io.realm.kotlin.internal.NotificationToken;
import io.realm.kotlin.internal.RealmImpl;
import io.realm.kotlin.internal.VersionTracker;
import io.realm.kotlin.internal.interop.CapiT;
import io.realm.kotlin.internal.interop.LiveRealmT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmSchemaT;
import io.realm.kotlin.internal.util.Validation;
import java.lang.ref.WeakReference;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001:\u0001+B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u001e\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u001fH\u0014J\u001a\u0010\"\u001a\u00020\u001f2\u0010\u0010#\u001a\f\u0012\u0004\u0012\u00020%0$j\u0002`&H\u0014J\r\u0010'\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b*R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lio/realm/kotlin/internal/LiveRealm;", "Lio/realm/kotlin/internal/BaseRealmImpl;", "owner", "Lio/realm/kotlin/internal/RealmImpl;", "configuration", "Lio/realm/kotlin/internal/InternalConfiguration;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/realm/kotlin/internal/RealmImpl;Lio/realm/kotlin/internal/InternalConfiguration;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_snapshot", "Lkotlinx/atomicfu/AtomicRef;", "Lio/realm/kotlin/internal/FrozenRealmReference;", "getOwner", "()Lio/realm/kotlin/internal/RealmImpl;", "realmChangeRegistration", "Lio/realm/kotlin/internal/NotificationToken;", "realmReference", "Lio/realm/kotlin/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/kotlin/internal/LiveRealmReference;", "realmReference$delegate", "Lkotlin/Lazy;", "schemaChangeRegistration", "snapshot", "getSnapshot$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/FrozenRealmReference;", "versionTracker", "Lio/realm/kotlin/internal/VersionTracker;", "getVersionTracker$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/VersionTracker;", "close", "", "close$io_realm_kotlin_library", "onRealmChanged", "onSchemaChanged", "schema", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSchemaT;", "Lio/realm/kotlin/internal/interop/RealmSchemaPointer;", "refresh", "refresh$io_realm_kotlin_library", "unregisterCallbacks", "unregisterCallbacks$io_realm_kotlin_library", "WeakLiveRealmCallback", "io.realm.kotlin.library"})
public abstract class LiveRealm
extends BaseRealmImpl {
    @NotNull
    private final RealmImpl owner;
    @NotNull
    private final NotificationToken realmChangeRegistration;
    @NotNull
    private final NotificationToken schemaChangeRegistration;
    @NotNull
    private final VersionTracker versionTracker;
    @NotNull
    private final Lazy realmReference$delegate;
    @NotNull
    private final AtomicRef<FrozenRealmReference> _snapshot;

    public LiveRealm(@NotNull RealmImpl owner, @NotNull InternalConfiguration configuration, @Nullable CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration);
        this.owner = owner;
        this.versionTracker = new VersionTracker(this.owner.getLog$io_realm_kotlin_library());
        this.realmReference$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LiveRealmReference>(configuration, dispatcher, this){
            final /* synthetic */ InternalConfiguration $configuration;
            final /* synthetic */ CoroutineDispatcher $dispatcher;
            final /* synthetic */ LiveRealm this$0;
            {
                this.$configuration = $configuration;
                this.$dispatcher = $dispatcher;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LiveRealmReference invoke() {
                Pair pair = RealmInterop.INSTANCE.realm_open(this.$configuration.createNativeConfiguration(), this.$dispatcher);
                NativePointer dbPointer = (NativePointer)pair.component1();
                boolean fileCreated = (Boolean)pair.component2();
                return new LiveRealmReference(this.this$0, (NativePointer<LiveRealmT>)dbPointer);
            }
        }));
        this._snapshot = AtomicFU.atomic(null);
        WeakLiveRealmCallback callback = new WeakLiveRealmCallback(this);
        this.realmChangeRegistration = new NotificationToken((NativePointer<? extends CapiT>)RealmInterop.INSTANCE.realm_add_realm_changed_callback(this.getRealmReference().getDbPointer(), (Function0)new Function0<Unit>((Object)callback){

            public final void invoke() {
                ((WeakLiveRealmCallback)this.receiver).onRealmChanged();
            }
        }));
        this.schemaChangeRegistration = new NotificationToken((NativePointer<? extends CapiT>)RealmInterop.INSTANCE.realm_add_schema_changed_callback(this.getRealmReference().getDbPointer(), (Function1)new Function1<NativePointer<RealmSchemaT>, Unit>((Object)callback){

            public final void invoke(@NotNull NativePointer<RealmSchemaT> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((WeakLiveRealmCallback)this.receiver).onSchemaChanged(p0);
            }
        }));
    }

    public /* synthetic */ LiveRealm(RealmImpl realmImpl, InternalConfiguration internalConfiguration, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineDispatcher = null;
        }
        this(realmImpl, internalConfiguration, coroutineDispatcher);
    }

    @NotNull
    public final RealmImpl getOwner() {
        return this.owner;
    }

    @NotNull
    public final VersionTracker getVersionTracker$io_realm_kotlin_library() {
        return this.versionTracker;
    }

    @Override
    @NotNull
    public LiveRealmReference getRealmReference() {
        Lazy lazy = this.realmReference$delegate;
        return (LiveRealmReference)lazy.getValue();
    }

    @NotNull
    public final FrozenRealmReference getSnapshot$io_realm_kotlin_library() {
        if (this._snapshot.getValue() == null) {
            FrozenRealmReference snapshot = this.getRealmReference().snapshot(this.owner);
            this.versionTracker.trackAndCloseExpiredReferences(snapshot);
            this._snapshot.setValue((Object)snapshot);
        }
        FrozenRealmReference frozenRealmReference = (FrozenRealmReference)this._snapshot.getValue();
        if (frozenRealmReference == null) {
            Validation.INSTANCE.sdkError("Snapshot should never be null");
            throw new KotlinNothingValueException();
        }
        return frozenRealmReference;
    }

    protected void onRealmChanged() {
        this._snapshot.setValue(null);
    }

    protected void onSchemaChanged(@NotNull NativePointer<RealmSchemaT> schema) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.getRealmReference().refreshSchemaMetadata();
    }

    public final void refresh$io_realm_kotlin_library() {
        RealmInterop.INSTANCE.realm_refresh(this.getRealmReference().getDbPointer());
    }

    public final void unregisterCallbacks$io_realm_kotlin_library() {
        this.realmChangeRegistration.cancel();
        this.schemaChangeRegistration.cancel();
    }

    @Override
    public void close$io_realm_kotlin_library() {
        this.unregisterCallbacks$io_realm_kotlin_library();
        this.versionTracker.close();
        this.getRealmReference().close();
        super.close$io_realm_kotlin_library();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/internal/LiveRealm$WeakLiveRealmCallback;", "", "liveRealm", "Lio/realm/kotlin/internal/LiveRealm;", "(Lio/realm/kotlin/internal/LiveRealm;)V", "realm", "Ljava/lang/ref/WeakReference;", "Lio/realm/kotlin/internal/platform/WeakReference;", "getRealm", "()Ljava/lang/ref/WeakReference;", "onRealmChanged", "", "onSchemaChanged", "schema", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSchemaT;", "Lio/realm/kotlin/internal/interop/RealmSchemaPointer;", "io.realm.kotlin.library"})
    private static final class WeakLiveRealmCallback {
        @NotNull
        private final WeakReference<LiveRealm> realm;

        public WeakLiveRealmCallback(@NotNull LiveRealm liveRealm) {
            Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
            this.realm = new WeakReference<LiveRealm>(liveRealm);
        }

        @NotNull
        public final WeakReference<LiveRealm> getRealm() {
            return this.realm;
        }

        public final void onRealmChanged() {
            block0: {
                LiveRealm liveRealm = (LiveRealm)this.realm.get();
                if (liveRealm == null) break block0;
                liveRealm.onRealmChanged();
            }
        }

        public final void onSchemaChanged(@NotNull NativePointer<RealmSchemaT> schema) {
            block0: {
                Intrinsics.checkNotNullParameter(schema, (String)"schema");
                LiveRealm liveRealm = (LiveRealm)this.realm.get();
                if (liveRealm == null) break block0;
                liveRealm.onSchemaChanged(schema);
            }
        }
    }
}

