/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.BaseRealmImpl;
import io.realm.kotlin.internal.ContextLogger;
import io.realm.kotlin.internal.FrozenRealmReference;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmT;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tRB\u0010\u0007\u001a6\u00122\u00120\u0012,\u0012*\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\f0\u000bj\u0002`\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00100\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/realm/kotlin/internal/VersionTracker;", "", "owner", "Lio/realm/kotlin/internal/BaseRealmImpl;", "log", "Lio/realm/kotlin/internal/ContextLogger;", "(Lio/realm/kotlin/internal/BaseRealmImpl;Lio/realm/kotlin/internal/ContextLogger;)V", "intermediateReferences", "Lkotlinx/atomicfu/AtomicRef;", "", "Lkotlin/Pair;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmT;", "Lio/realm/kotlin/internal/interop/RealmPointer;", "Ljava/lang/ref/WeakReference;", "Lio/realm/kotlin/internal/RealmReference;", "Lio/realm/kotlin/internal/platform/WeakReference;", "close", "", "trackAndCloseExpiredReferences", "realmReference", "Lio/realm/kotlin/internal/FrozenRealmReference;", "versions", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
public final class VersionTracker {
    @NotNull
    private final BaseRealmImpl owner;
    @NotNull
    private final ContextLogger log;
    @NotNull
    private final AtomicRef<Set<Pair<NativePointer<? extends RealmT>, WeakReference<RealmReference>>>> intermediateReferences;

    public VersionTracker(@NotNull BaseRealmImpl owner, @NotNull ContextLogger log) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.owner = owner;
        this.log = log;
        this.intermediateReferences = AtomicFU.atomic((Object)new LinkedHashSet());
    }

    public final void trackAndCloseExpiredReferences(@Nullable FrozenRealmReference realmReference2) {
        Set references = new LinkedHashSet();
        FrozenRealmReference frozenRealmReference = realmReference2;
        if (frozenRealmReference != null) {
            FrozenRealmReference it = frozenRealmReference;
            boolean bl = false;
            this.log.trace(this.owner + " TRACK-VERSION " + realmReference2.version(), new Object[0]);
            references.add(new Pair(realmReference2.getDbPointer(), new WeakReference<FrozenRealmReference>(it)));
        }
        Iterable $this$forEach$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair entry = (Pair)element$iv;
            boolean bl = false;
            NativePointer pointer = (NativePointer)entry.component1();
            WeakReference ref = (WeakReference)entry.component2();
            if (ref.get() == null) {
                this.log.trace(this.owner + " CLOSE-FREED " + RealmInterop.INSTANCE.realm_get_version_id(pointer), new Object[0]);
                RealmInterop.INSTANCE.realm_close(pointer);
                continue;
            }
            references.add(entry);
        }
        this.intermediateReferences.setValue((Object)references);
    }

    public static /* synthetic */ void trackAndCloseExpiredReferences$default(VersionTracker versionTracker, FrozenRealmReference frozenRealmReference, int n, Object object) {
        if ((n & 1) != 0) {
            frozenRealmReference = null;
        }
        versionTracker.trackAndCloseExpiredReferences(frozenRealmReference);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<VersionId> versions() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VersionId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            RealmReference realmReference2 = (RealmReference)((WeakReference)it.getSecond()).get();
            if ((realmReference2 != null ? realmReference2.version() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void close() {
        Iterable $this$forEach$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            NativePointer pointer = (NativePointer)pair.component1();
            this.log.trace(this.owner + " CLOSE-ACTIVE " + new VersionId(RealmInterop.INSTANCE.realm_get_version_id(pointer)), new Object[0]);
            RealmInterop.INSTANCE.realm_close(pointer);
        }
    }
}

