/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.internal.Flowable;
import io.realm.kotlin.internal.ObjectBoundRealmResultsKt;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.query.ObjectBoundQuery;
import io.realm.kotlin.notifications.ResultsChange;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0004B\u001f\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0096\u0001J\u0016\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\rH\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010!J\t\u0010\"\u001a\u00020\u0017H\u0096\u0001J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0096\u0003J\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010!J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0096\u0001J\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'2\u0006\u0010\u001e\u001a\u00020\rH\u0096\u0001J3\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0006\u0010(\u001a\u00020*2\u0016\u0010+\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010-0,\"\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010.J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u0000002\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0096\u0001J\t\u00103\u001a\u000204H\u0096\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011*\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00065"}, d2={"Lio/realm/kotlin/internal/ObjectBoundRealmResults;", "E", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/query/RealmResults;", "Lio/realm/kotlin/internal/Flowable;", "Lio/realm/kotlin/notifications/ResultsChange;", "targetObject", "Lio/realm/kotlin/internal/RealmObjectReference;", "realmResults", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/query/RealmResults;)V", "getRealmResults", "()Lio/realm/kotlin/query/RealmResults;", "size", "", "getSize$delegate", "(Lio/realm/kotlin/internal/ObjectBoundRealmResults;)Ljava/lang/Object;", "getSize", "()I", "getTargetObject", "()Lio/realm/kotlin/internal/RealmObjectReference;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "contains", "", "element", "(Lio/realm/kotlin/types/BaseRealmObject;)Z", "containsAll", "elements", "", "get", "index", "(I)Lio/realm/kotlin/types/BaseRealmObject;", "indexOf", "(Lio/realm/kotlin/types/BaseRealmObject;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "query", "Lio/realm/kotlin/query/RealmQuery;", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "subList", "", "fromIndex", "toIndex", "version", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
public final class ObjectBoundRealmResults<E extends BaseRealmObject>
implements RealmResults<E>,
Flowable<ResultsChange<E>> {
    @NotNull
    private final RealmObjectReference<?> targetObject;
    @NotNull
    private final RealmResults<E> realmResults;

    public ObjectBoundRealmResults(@NotNull RealmObjectReference<?> targetObject, @NotNull RealmResults<E> realmResults) {
        Intrinsics.checkNotNullParameter(targetObject, (String)"targetObject");
        Intrinsics.checkNotNullParameter(realmResults, (String)"realmResults");
        this.targetObject = targetObject;
        this.realmResults = realmResults;
    }

    @NotNull
    public final RealmObjectReference<?> getTargetObject() {
        return this.targetObject;
    }

    @NotNull
    public final RealmResults<E> getRealmResults() {
        return this.realmResults;
    }

    @Override
    public boolean contains(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.realmResults.containsAll(elements);
    }

    @Override
    public int indexOf(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.realmResults.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.realmResults.iterator();
    }

    @Override
    public int lastIndexOf(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.realmResults.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return this.realmResults.listIterator(index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.realmResults.subList(fromIndex, toIndex);
    }

    @Override
    @NotNull
    public VersionId version() {
        return this.realmResults.version();
    }

    public int getSize() {
        return this.realmResults.size();
    }

    private static Object getSize$delegate(ObjectBoundRealmResults<BaseRealmObject> objectBoundRealmResults) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(objectBoundRealmResults.realmResults, RealmResults.class, "size", "size()I", 0)));
    }

    @Override
    @NotNull
    public E get(int index) {
        return (E)((BaseRealmObject)this.realmResults.get(index));
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String query, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmResults.query(query, Arrays.copyOf(args, args.length)));
    }

    @Override
    @NotNull
    public Flow<ResultsChange<E>> asFlow() {
        return ObjectBoundRealmResultsKt.bind(this.realmResults.asFlow(), this.targetObject);
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<E> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super E> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

