/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.MapOperator;
import io.realm.kotlin.internal.interop.JvmMemAllocator;
import io.realm.kotlin.internal.interop.MemAllocator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u000e\u0010\u0014\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/realm/kotlin/internal/RealmMapGenericIterator;", "K", "T", "", "operator", "Lio/realm/kotlin/internal/MapOperator;", "(Lio/realm/kotlin/internal/MapOperator;)V", "cursor", "", "expectedModCount", "lastReturned", "getOperator", "()Lio/realm/kotlin/internal/MapOperator;", "checkConcurrentModification", "", "getNext", "position", "(I)Ljava/lang/Object;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmMapInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmMapInternal.kt\nio/realm/kotlin/internal/RealmMapGenericIterator\n+ 2 RealmValueAllocator.kt\nio/realm/kotlin/internal/interop/RealmValueAllocatorKt\n*L\n1#1,1086:1\n192#2:1087\n189#2:1088\n*S KotlinDebug\n*F\n+ 1 RealmMapInternal.kt\nio/realm/kotlin/internal/RealmMapGenericIterator\n*L\n864#1:1087\n864#1:1088\n*E\n"})
public abstract class RealmMapGenericIterator<K, T>
implements Iterator<T>,
KMutableIterator {
    @NotNull
    private final MapOperator<K, ?> operator;
    private int expectedModCount;
    private int cursor;
    private int lastReturned;

    public RealmMapGenericIterator(@NotNull MapOperator<K, ?> operator) {
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.operator = operator;
        this.expectedModCount = this.operator.getModCount();
        this.lastReturned = -1;
    }

    @NotNull
    protected final MapOperator<K, ?> getOperator() {
        return this.operator;
    }

    public abstract T getNext(int var1);

    @Override
    public boolean hasNext() {
        this.checkConcurrentModification();
        return this.cursor < this.operator.getSize();
    }

    @Override
    public void remove() {
        this.checkConcurrentModification();
        if (this.operator.getSize() == 0) {
            throw new NoSuchElementException("Could not remove last element returned by the iterator: dictionary is empty.");
        }
        if (this.lastReturned < 0) {
            throw new IllegalStateException("Could not remove last element returned by the iterator: iterator never returned an element.");
        }
        boolean $i$f$getterScope = false;
        boolean $i$f$realmValueAllocator = false;
        MemAllocator $this$remove_u24lambda_u241 = (MemAllocator)JvmMemAllocator.INSTANCE;
        boolean bl = false;
        Pair<K, ?> keyValuePair = this.operator.getEntry(this.lastReturned);
        Object object = this.operator.erase(keyValuePair.getFirst()).getSecond();
        boolean it = (Boolean)object;
        boolean bl2 = false;
        if (this.lastReturned < this.cursor) {
            --this.cursor;
        }
        this.lastReturned = -1;
        boolean erased = (Boolean)object;
        this.expectedModCount = this.operator.getModCount();
        if (!erased) {
            throw new NoSuchElementException("Could not remove last element returned by the iterator: was there an element to remove?");
        }
    }

    @Override
    public T next() {
        this.checkConcurrentModification();
        int position = this.cursor;
        if (position >= this.operator.getSize()) {
            throw new IndexOutOfBoundsException("Cannot access index " + position + " when size is " + this.operator.getSize() + ". Remember to check hasNext() before using next().");
        }
        T next = this.getNext(position);
        this.lastReturned = position;
        this.cursor = position + 1;
        return next;
    }

    private final void checkConcurrentModification() {
        if (this.operator.getModCount() != this.expectedModCount) {
            throw new ConcurrentModificationException("The underlying RealmDictionary was modified while iterating over its entry set.");
        }
    }
}

