/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.schema;

import io.realm.kotlin.internal.interop.CollectionType;
import io.realm.kotlin.internal.interop.PropertyInfo;
import io.realm.kotlin.internal.schema.RealmStorageTypeImpl;
import io.realm.kotlin.schema.ListPropertyType;
import io.realm.kotlin.schema.MapPropertyType;
import io.realm.kotlin.schema.RealmProperty;
import io.realm.kotlin.schema.RealmPropertyType;
import io.realm.kotlin.schema.RealmStorageType;
import io.realm.kotlin.schema.SetPropertyType;
import io.realm.kotlin.schema.ValuePropertyType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/internal/schema/RealmPropertyImpl;", "Lio/realm/kotlin/schema/RealmProperty;", "name", "", "type", "Lio/realm/kotlin/schema/RealmPropertyType;", "(Ljava/lang/String;Lio/realm/kotlin/schema/RealmPropertyType;)V", "isNullable", "", "()Z", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getType", "()Lio/realm/kotlin/schema/RealmPropertyType;", "setType", "(Lio/realm/kotlin/schema/RealmPropertyType;)V", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "io.realm.kotlin.library"})
public final class RealmPropertyImpl
implements RealmProperty {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private RealmPropertyType type;
    private final boolean isNullable;

    public RealmPropertyImpl(@NotNull String name, @NotNull RealmPropertyType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.name = name;
        this.type = type;
        RealmPropertyType realmPropertyType = this.getType();
        if (realmPropertyType instanceof ValuePropertyType) {
            bl = this.getType().isNullable();
        } else if (realmPropertyType instanceof ListPropertyType) {
            bl = false;
        } else if (realmPropertyType instanceof SetPropertyType) {
            bl = false;
        } else if (realmPropertyType instanceof MapPropertyType) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.isNullable = bl;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @NotNull
    public RealmPropertyType getType() {
        return this.type;
    }

    public void setType(@NotNull RealmPropertyType realmPropertyType) {
        Intrinsics.checkNotNullParameter((Object)realmPropertyType, (String)"<set-?>");
        this.type = realmPropertyType;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final RealmPropertyType component2() {
        return this.type;
    }

    @NotNull
    public final RealmPropertyImpl copy(@NotNull String name, @NotNull RealmPropertyType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new RealmPropertyImpl(name, type);
    }

    public static /* synthetic */ RealmPropertyImpl copy$default(RealmPropertyImpl realmPropertyImpl, String string, RealmPropertyType realmPropertyType, int n, Object object) {
        if ((n & 1) != 0) {
            string = realmPropertyImpl.name;
        }
        if ((n & 2) != 0) {
            realmPropertyType = realmPropertyImpl.type;
        }
        return realmPropertyImpl.copy(string, realmPropertyType);
    }

    @NotNull
    public String toString() {
        return "RealmPropertyImpl(name=" + this.name + ", type=" + this.type + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RealmPropertyImpl)) {
            return false;
        }
        RealmPropertyImpl realmPropertyImpl = (RealmPropertyImpl)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)realmPropertyImpl.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)realmPropertyImpl.type);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/realm/kotlin/internal/schema/RealmPropertyImpl$Companion;", "", "()V", "fromCoreProperty", "Lio/realm/kotlin/internal/schema/RealmPropertyImpl;", "corePropertyImpl", "Lio/realm/kotlin/internal/interop/PropertyInfo;", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RealmPropertyImpl fromCoreProperty(@NotNull PropertyInfo corePropertyImpl) {
            RealmPropertyType realmPropertyType;
            Intrinsics.checkNotNullParameter((Object)corePropertyImpl, (String)"corePropertyImpl");
            PropertyInfo $this$fromCoreProperty_u24lambda_u240 = corePropertyImpl;
            boolean bl = false;
            RealmStorageType storageType = RealmStorageTypeImpl.INSTANCE.fromCorePropertyType($this$fromCoreProperty_u24lambda_u240.getType());
            switch (WhenMappings.$EnumSwitchMapping$0[$this$fromCoreProperty_u24lambda_u240.getCollectionType().ordinal()]) {
                case 1: {
                    realmPropertyType = new ValuePropertyType(storageType, $this$fromCoreProperty_u24lambda_u240.isNullable(), $this$fromCoreProperty_u24lambda_u240.isPrimaryKey(), $this$fromCoreProperty_u24lambda_u240.isIndexed(), $this$fromCoreProperty_u24lambda_u240.isFullTextIndexed());
                    break;
                }
                case 2: {
                    realmPropertyType = new ListPropertyType(storageType, $this$fromCoreProperty_u24lambda_u240.isNullable(), $this$fromCoreProperty_u24lambda_u240.isComputed());
                    break;
                }
                case 3: {
                    realmPropertyType = new SetPropertyType(storageType, $this$fromCoreProperty_u24lambda_u240.isNullable());
                    break;
                }
                case 4: {
                    realmPropertyType = new MapPropertyType(storageType, $this$fromCoreProperty_u24lambda_u240.isNullable());
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported type " + $this$fromCoreProperty_u24lambda_u240.getCollectionType()).toString());
                }
            }
            RealmPropertyType type = realmPropertyType;
            return new RealmPropertyImpl($this$fromCoreProperty_u24lambda_u240.getName(), type);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CollectionType.values().length];
                try {
                    nArray[CollectionType.RLM_COLLECTION_TYPE_NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CollectionType.RLM_COLLECTION_TYPE_LIST.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CollectionType.RLM_COLLECTION_TYPE_SET.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CollectionType.RLM_COLLECTION_TYPE_DICTIONARY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

