/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.ManagedRealmMapEntry;
import io.realm.kotlin.internal.MapOperator;
import io.realm.kotlin.internal.RealmMapGenericIterator;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmMapT;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u00032$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0006j\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002`\u0005B;\u0012\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\"\u0010\u0019\u001a\u00020\u00172\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001b\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u001fH\u0096\u0002J\u001c\u0010 \u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\"\u0010!\u001a\u00020\u00172\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u001bH\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lio/realm/kotlin/internal/RealmMapEntrySetImpl;", "K", "V", "Lkotlin/collections/AbstractMutableSet;", "", "Lio/realm/kotlin/internal/RealmMapEntrySet;", "", "nativePointer", "Lio/realm/kotlin/internal/interop/RealmMapPointer;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmMapT;", "operator", "Lio/realm/kotlin/internal/MapOperator;", "parent", "Lio/realm/kotlin/internal/RealmObjectReference;", "<init>", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/MapOperator;Lio/realm/kotlin/internal/RealmObjectReference;)V", "Lio/realm/kotlin/internal/interop/NativePointer;", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "iterator", "", "remove", "removeAll", "toString", "", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmMapInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmMapInternal.kt\nio/realm/kotlin/internal/RealmMapEntrySetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1254:1\n1797#2,3:1255\n1797#2,3:1258\n*S KotlinDebug\n*F\n+ 1 RealmMapInternal.kt\nio/realm/kotlin/internal/RealmMapEntrySetImpl\n*L\n1109#1:1255,3\n1136#1:1258,3\n*E\n"})
public final class RealmMapEntrySetImpl<K, V>
extends AbstractMutableSet<Map.Entry<K, V>>
implements Set<Map.Entry<K, V>>,
KMutableSet {
    @NotNull
    private final NativePointer<RealmMapT> nativePointer;
    @NotNull
    private final MapOperator<K, V> operator;
    @Nullable
    private final RealmObjectReference<?> parent;

    public RealmMapEntrySetImpl(@NotNull NativePointer<RealmMapT> nativePointer, @NotNull MapOperator<K, V> operator, @Nullable RealmObjectReference<?> parent) {
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.nativePointer = nativePointer;
        this.operator = operator;
        this.parent = parent;
    }

    public int getSize() {
        return (int)RealmInterop.INSTANCE.realm_dictionary_size(this.nativePointer);
    }

    @Override
    public boolean add(@NotNull Map.Entry<K, V> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return (Boolean)MapOperator.DefaultImpls.insert$default(this.operator, element.getKey(), element.getValue(), null, null, 12, null).getSecond();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(@NotNull Collection<? extends Map.Entry<K, V>> elements) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable iterable = elements;
        boolean initial$iv = false;
        boolean $i$f$fold = false;
        boolean accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            boolean accumulator = accumulator$iv;
            boolean bl = false;
            accumulator$iv = (Boolean)MapOperator.DefaultImpls.insert$default(this.operator, entry.getKey(), entry.getValue(), null, null, 12, null).getSecond() | accumulator;
        }
        return accumulator$iv;
    }

    @Override
    public void clear() {
        this.operator.clear();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        MapOperator<K, V> mapOperator = this.operator;
        return new RealmMapGenericIterator<K, Map.Entry<K, V>>(mapOperator){

            public Map.Entry<K, V> getNext(int position) {
                Pair<K, ?> pair = this.getOperator().getEntry(position);
                return TypeIntrinsics.asMutableMapEntry(new ManagedRealmMapEntry<Object, ?>(pair.getFirst(), this.getOperator()));
            }
        };
    }

    public boolean remove(@NotNull Map.Entry<K, V> element) {
        boolean bl;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        V value = this.operator.get(element.getKey());
        boolean bl2 = false;
        boolean bl3 = this.operator.areValuesEqual(value, element.getValue());
        if (bl3) {
            bl = (Boolean)this.operator.erase(element.getKey()).getSecond();
        } else if (!bl3) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable iterable = elements;
        boolean initial$iv = false;
        boolean $i$f$fold = false;
        boolean accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            boolean accumulator = accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.remove(entry) | accumulator;
        }
        return accumulator$iv;
    }

    @NotNull
    public String toString() {
        Triple triple;
        RealmObjectReference<?> realmObjectReference = this.parent;
        if (realmObjectReference != null) {
            RealmObjectReference<?> $this$toString_u24lambda_u243 = realmObjectReference;
            boolean bl = false;
            triple = new Triple((Object)$this$toString_u24lambda_u243.getClassName(), (Object)$this$toString_u24lambda_u243.getOwner().version().getVersion(), (Object)RealmInterop.INSTANCE.realm_object_get_key-uruzcz0(this.parent.getObjectPointer()));
        } else {
            triple = new Triple((Object)"null", (Object)this.operator.getRealmReference().getOwner().version(), (Object)"null");
        }
        Triple triple2 = triple;
        String owner = (String)triple2.component1();
        Comparable version = (Comparable)triple2.component2();
        Object objKey = triple2.component3();
        return "RealmDictionary.entries{size=" + this.size() + ",owner=" + owner + ",objKey=" + objKey + ",version=" + version + '}';
    }
}

