/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.types.geo;

import io.realm.kotlin.annotations.ExperimentalGeoSpatialApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalGeoSpatialApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/realm/kotlin/types/geo/Distance;", "", "radians", "", "<init>", "(D)V", "inRadians", "getInRadians", "()D", "inDegrees", "getInDegrees", "inKilometers", "getInKilometers", "inMiles", "getInMiles", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "io.realm.kotlin.library"})
public final class Distance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double radians;
    private static final double DEGREE_TO_RADIAN = Math.PI / 180;
    private static final double RADIAN_TO_DEGREE = 57.29577951308232;
    public static final double EARTH_RADIUS_KM = 6371.0;
    public static final double KM_PR_MILE = 1.609344;

    private Distance(double radians) {
        this.radians = radians;
        if (this.radians < 0.0) {
            throw new IllegalArgumentException("Negative distance is now allowed: " + this.radians);
        }
    }

    public final double getInRadians() {
        return this.radians;
    }

    public final double getInDegrees() {
        return this.radians * 57.29577951308232;
    }

    public final double getInKilometers() {
        double result = this.radians * 6371.0;
        return this.radians == 0.0 ? 0.0 : (result < this.radians ? Double.POSITIVE_INFINITY : result);
    }

    public final double getInMiles() {
        double result = this.radians * 6371.0 / 1.609344;
        return this.radians == 0.0 ? 0.0 : (result < this.radians ? Double.POSITIVE_INFINITY : result);
    }

    private final double component1() {
        return this.radians;
    }

    @NotNull
    public final Distance copy(double radians) {
        return new Distance(radians);
    }

    public static /* synthetic */ Distance copy$default(Distance distance, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = distance.radians;
        }
        return distance.copy(d);
    }

    @NotNull
    public String toString() {
        return "Distance(radians=" + this.radians + ')';
    }

    public int hashCode() {
        return Double.hashCode(this.radians);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Distance)) {
            return false;
        }
        Distance distance = (Distance)other;
        return Double.compare(this.radians, distance.radians) == 0;
    }

    public /* synthetic */ Distance(double radians, DefaultConstructorMarker $constructor_marker) {
        this(radians);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/realm/kotlin/types/geo/Distance$Companion;", "", "<init>", "()V", "DEGREE_TO_RADIAN", "", "RADIAN_TO_DEGREE", "EARTH_RADIUS_KM", "KM_PR_MILE", "fromKilometers", "Lio/realm/kotlin/types/geo/Distance;", "km", "fromMiles", "miles", "fromRadians", "radians", "fromDegrees", "degrees", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Distance fromKilometers(double km) {
            return km == 0.0 ? new Distance(0.0, null) : new Distance(km / 6371.0, null);
        }

        @NotNull
        public final Distance fromMiles(double miles) {
            return miles == 0.0 ? new Distance(0.0, null) : new Distance(miles * 1.609344 / 6371.0, null);
        }

        @NotNull
        public final Distance fromRadians(double radians) {
            return new Distance(radians, null);
        }

        @NotNull
        public final Distance fromDegrees(double degrees) {
            return new Distance(degrees * (Math.PI / 180), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

