/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import android.util.Log;
import io.realm.kotlin.internal.LogUtilsKt;
import io.realm.kotlin.log.LogCategory;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JI\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J9\u0010\u0017\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/realm/kotlin/internal/platform/LogCatLogger;", "Lio/realm/kotlin/log/RealmLogger;", "tag", "", "<init>", "(Ljava/lang/String;)V", "log", "", "category", "Lio/realm/kotlin/log/LogCategory;", "level", "Lio/realm/kotlin/log/LogLevel;", "throwable", "", "message", "args", "", "", "(Lio/realm/kotlin/log/LogCategory;Lio/realm/kotlin/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "printMessage", "priority", "", "logMessage", "prepareLogMessage", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "formatMessage", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "t", "Companion", "io.realm.kotlin.library"})
public final class LogCatLogger
implements RealmLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    private static final int MAX_TAG_LENGTH = 23;
    private static final int MAX_LOG_LENGTH = 4000;
    private static final int INITIAL_BUFFER_SIZE = 256;

    public LogCatLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
    }

    @Override
    public void log(@NotNull LogCategory category, @NotNull LogLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int priority = level.getPriority();
        String logMessage = this.prepareLogMessage(throwable, LogUtilsKt.messageWithCategory(category, message), Arrays.copyOf(args, args.length));
        if (logMessage.length() < 4000) {
            this.printMessage(priority, logMessage);
            return;
        }
        int length = logMessage.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = StringsKt.indexOf$default((CharSequence)logMessage, (char)'\n', (int)i, (boolean)false, (int)4, null);
            newline = newline != -1 ? newline : length;
            do {
                String part;
                end = Math.min(newline, i + 4000);
                Intrinsics.checkNotNullExpressionValue((Object)logMessage.substring(i, end), (String)"substring(...)");
                this.printMessage(priority, part);
            } while ((i = end) < newline);
        }
    }

    private final void printMessage(int priority, String logMessage) {
        int n = priority <= LogLevel.TRACE.getPriority() ? Log.v((String)this.tag, (String)logMessage) : (priority == LogLevel.DEBUG.getPriority() ? Log.d((String)this.tag, (String)logMessage) : (priority == LogLevel.WTF.getPriority() ? Log.wtf((String)this.tag, (String)logMessage) : Log.println((int)priority, (String)this.tag, (String)logMessage)));
    }

    private final String prepareLogMessage(Throwable throwable, String message, Object ... args) {
        String messageToLog = message;
        CharSequence charSequence = messageToLog;
        if (charSequence == null || charSequence.length() == 0) {
            if (throwable == null) {
                return "";
            }
            messageToLog = this.getStackTraceString(throwable);
        } else {
            if (!(args.length == 0)) {
                messageToLog = this.formatMessage(messageToLog, Arrays.copyOf(args, args.length));
            }
            if (throwable != null) {
                messageToLog = messageToLog + '\n' + this.getStackTraceString(throwable);
            }
        }
        return messageToLog;
    }

    private final String formatMessage(String message, Object ... args) {
        String string = message;
        Locale locale = Locale.US;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/internal/platform/LogCatLogger$Companion;", "", "<init>", "()V", "MAX_TAG_LENGTH", "", "getMAX_TAG_LENGTH$annotations", "MAX_LOG_LENGTH", "INITIAL_BUFFER_SIZE", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getMAX_TAG_LENGTH$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

