/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.query;

import io.realm.kotlin.internal.interop.PropertyType;
import io.realm.kotlin.internal.schema.PropertyMetadata;
import io.realm.kotlin.types.RealmAny;
import io.realm.kotlin.types.RealmInstant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonDecimal128;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a$\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00132\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u0007H\u0002\u00a8\u0006\u0015"}, d2={"queryTypeValidator", "", "T", "", "propertyMetadata", "Lio/realm/kotlin/internal/schema/PropertyMetadata;", "type", "Lkotlin/reflect/KClass;", "validateTimestamp", "", "coerceLong", "propertyName", "", "value", "", "coercedType", "coerceFloat", "", "coerceDouble", "", "isNumeric", "io.realm.kotlin.library"})
public final class ScalarQueryKt {
    private static final <T> void queryTypeValidator(PropertyMetadata propertyMetadata, KClass<T> type, boolean validateTimestamp) {
        PropertyType fieldType = propertyMetadata.getType();
        if (fieldType == PropertyType.RLM_PROPERTY_TYPE_MIXED) {
            if (!Intrinsics.areEqual(type, (Object)Reflection.getOrCreateKotlinClass(RealmAny.class))) {
                throw new IllegalArgumentException("RealmAny properties cannot be aggregated as '" + type.getSimpleName() + "'. Use RealmAny as output type instead.");
            }
        } else if (fieldType == PropertyType.RLM_PROPERTY_TYPE_DECIMAL128) {
            if (!Intrinsics.areEqual(type, (Object)Reflection.getOrCreateKotlinClass(BsonDecimal128.class))) {
                throw new IllegalArgumentException("Decimal128 properties cannot be aggregated as '" + type.getSimpleName() + "'. Use Decimal128 as output type instead.");
            }
        } else if (validateTimestamp && fieldType == PropertyType.RLM_PROPERTY_TYPE_TIMESTAMP) {
            if (!Intrinsics.areEqual(type, (Object)Reflection.getOrCreateKotlinClass(RealmInstant.class))) {
                throw new IllegalArgumentException("Conversion not possible between '" + fieldType + "' and '" + type.getSimpleName() + "'.");
            }
        } else if (ScalarQueryKt.isNumeric(type)) {
            if (fieldType != PropertyType.RLM_PROPERTY_TYPE_INT && fieldType != PropertyType.RLM_PROPERTY_TYPE_FLOAT && fieldType != PropertyType.RLM_PROPERTY_TYPE_DOUBLE) {
                throw new IllegalArgumentException("Conversion not possible between '" + fieldType + "' and '" + type.getSimpleName() + "'.");
            }
        } else {
            throw new IllegalArgumentException("Conversion not possible between '" + fieldType + "' and '" + type.getSimpleName() + "'.");
        }
    }

    static /* synthetic */ void queryTypeValidator$default(PropertyMetadata propertyMetadata, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ScalarQueryKt.queryTypeValidator(propertyMetadata, kClass, bl);
    }

    @NotNull
    public static final Object coerceLong(@NotNull String propertyName, long value, @NotNull KClass<?> coercedType) {
        Comparable<Short> comparable;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter(coercedType, (String)"coercedType");
        KClass<?> kClass = coercedType;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            comparable = (short)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            comparable = (int)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            comparable = (byte)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            comparable = Character.valueOf((char)value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            comparable = value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            comparable = value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            comparable = Float.valueOf(value);
        } else {
            throw new IllegalArgumentException("Cannot coerce type of property '" + propertyName + "' to '" + coercedType.getSimpleName() + "'.");
        }
        return comparable;
    }

    @NotNull
    public static final Object coerceFloat(@NotNull String propertyName, float value, @NotNull KClass<?> coercedType) {
        Comparable<Short> comparable;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter(coercedType, (String)"coercedType");
        KClass<?> kClass = coercedType;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            comparable = (short)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            comparable = (int)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            comparable = (byte)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            comparable = Character.valueOf((char)value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            comparable = (int)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            comparable = value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            comparable = Float.valueOf(value);
        } else {
            throw new IllegalArgumentException("Cannot coerce type of property '$" + propertyName + "' to '" + coercedType.getSimpleName() + "'.");
        }
        return comparable;
    }

    @NotNull
    public static final Object coerceDouble(@NotNull String propertyName, double value, @NotNull KClass<?> coercedType) {
        Comparable<Short> comparable;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter(coercedType, (String)"coercedType");
        KClass<?> kClass = coercedType;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            comparable = (short)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            comparable = (int)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            comparable = (byte)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            comparable = Character.valueOf((char)value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            comparable = (int)value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            comparable = value;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            comparable = Float.valueOf((float)value);
        } else {
            throw new IllegalArgumentException("Cannot coerce type of property '$" + propertyName + "' to '" + coercedType.getSimpleName() + "'.");
        }
        return comparable;
    }

    private static final boolean isNumeric(KClass<?> $this$isNumeric) {
        return Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) || Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE)) || Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)) || Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) || Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) || Intrinsics.areEqual($this$isNumeric, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE));
    }

    public static final /* synthetic */ void access$queryTypeValidator(PropertyMetadata propertyMetadata, KClass type, boolean validateTimestamp) {
        ScalarQueryKt.queryTypeValidator(propertyMetadata, type, validateTimestamp);
    }
}

