/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.Versioned;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.ObjectBoundRealmResultsKt;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.query.ObjectBoundQuery;
import io.realm.kotlin.notifications.ResultsChange;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B!\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J3\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0017\u001a\u00020\u00192\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 0\u001f2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0011\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u0000H\u0096\u0003J\u0017\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0096\u0001J\u0011\u0010+\u001a\u00020\u000f2\u0006\u0010'\u001a\u00028\u0000H\u0096\u0001J\t\u0010,\u001a\u00020&H\u0096\u0001J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.H\u0096\u0003J\u0011\u0010/\u001a\u00020\u000f2\u0006\u0010'\u001a\u00028\u0000H\u0096\u0001J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0096\u0001J\u0017\u00100\u001a\b\u0012\u0004\u0012\u00028\u0000012\u0006\u0010\u0015\u001a\u00020\u000fH\u0096\u0001J\u001f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000fH\u0096\u0001J\t\u00105\u001a\u000206H\u0096\u0001R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013*\u0004\b\u0010\u0010\u0011\u00a8\u00067"}, d2={"Lio/realm/kotlin/internal/ObjectBoundRealmResults;", "E", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/query/RealmResults;", "Lio/realm/kotlin/internal/InternalDeleteable;", "targetObject", "Lio/realm/kotlin/internal/RealmObjectReference;", "realmResults", "<init>", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/query/RealmResults;)V", "getTargetObject", "()Lio/realm/kotlin/internal/RealmObjectReference;", "getRealmResults", "()Lio/realm/kotlin/query/RealmResults;", "size", "", "getSize$delegate", "(Lio/realm/kotlin/internal/ObjectBoundRealmResults;)Ljava/lang/Object;", "getSize", "()I", "get", "index", "(I)Lio/realm/kotlin/types/BaseRealmObject;", "query", "Lio/realm/kotlin/query/RealmQuery;", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/kotlin/notifications/ResultsChange;", "keyPaths", "", "delete", "", "contains", "", "element", "containsAll", "elements", "", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "version", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
public final class ObjectBoundRealmResults<E extends BaseRealmObject>
implements RealmResults<E>,
InternalDeleteable {
    @NotNull
    private final RealmObjectReference<?> targetObject;
    @NotNull
    private final RealmResults<E> realmResults;

    public ObjectBoundRealmResults(@NotNull RealmObjectReference<?> targetObject, @NotNull RealmResults<E> realmResults) {
        Intrinsics.checkNotNullParameter(targetObject, (String)"targetObject");
        Intrinsics.checkNotNullParameter(realmResults, (String)"realmResults");
        this.targetObject = targetObject;
        this.realmResults = realmResults;
    }

    @NotNull
    public final RealmObjectReference<?> getTargetObject() {
        return this.targetObject;
    }

    @NotNull
    public final RealmResults<E> getRealmResults() {
        return this.realmResults;
    }

    @Override
    public boolean contains(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.realmResults.containsAll(elements);
    }

    @Override
    public int indexOf(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.realmResults.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.realmResults.iterator();
    }

    @Override
    public int lastIndexOf(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.realmResults.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.realmResults.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return this.realmResults.listIterator(index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.realmResults.subList(fromIndex, toIndex);
    }

    @Override
    @NotNull
    public VersionId version() {
        return ((Versioned)this.realmResults).version();
    }

    public int getSize() {
        return this.realmResults.size();
    }

    private static Object getSize$delegate(ObjectBoundRealmResults<BaseRealmObject> objectBoundRealmResults) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(objectBoundRealmResults.realmResults, RealmResults.class, "size", "size()I", 0)));
    }

    @Override
    @NotNull
    public E get(int index) {
        return (E)((BaseRealmObject)this.realmResults.get(index));
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String query, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectBoundQuery<E>(this.targetObject, this.realmResults.query(query, Arrays.copyOf(args, args.length)));
    }

    @Override
    @NotNull
    public Flow<ResultsChange<E>> asFlow(@Nullable List<String> keyPaths) {
        return ObjectBoundRealmResultsKt.bind(this.realmResults.asFlow(keyPaths), this.targetObject);
    }

    @Override
    public void delete() {
        if (!(this.realmResults instanceof InternalDeleteable)) {
            throw new IllegalStateException("This class cannot be deleted: " + this + ". It was holding a " + this.realmResults);
        }
        ((InternalDeleteable)((Object)this.realmResults)).delete();
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<E> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super E> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

