/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.VersionId;
import io.realm.kotlin.Versioned;
import io.realm.kotlin.internal.ChangeFlow;
import io.realm.kotlin.internal.CoreNotifiable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.LiveRealm;
import io.realm.kotlin.internal.Notifiable;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectSetOperator;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.RealmSetChangeFlow;
import io.realm.kotlin.internal.SetOperator;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.ClassKey;
import io.realm.kotlin.internal.interop.JvmMemAllocator;
import io.realm.kotlin.internal.interop.MemAllocator;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmKeyPathArrayT;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.internal.interop.RealmSetT;
import io.realm.kotlin.internal.util.Validation;
import io.realm.kotlin.notifications.SetChange;
import io.realm.kotlin.types.RealmSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00052\u00020\u0007B5\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u0012\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010$\u001a\u00020\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0096\u0002J$\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016J\u0018\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00102\u001a\u000200H\u0016J@\u00103\u001a\f\u0012\u0004\u0012\u0002040\u000bj\u0002`52\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u000206\u0018\u00010\u000bj\u0004\u0018\u0001`72\u0016\u00108\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020:0\u000bj\u0002`;09H\u0016J4\u0010<\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060=2\u0012\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060?H\u0016J\b\u0010@\u001a\u00020!H\u0016J\b\u0010A\u001a\u00020\u001dH\u0016J\t\u0010B\u001a\u00020CH\u0096\u0001R\u001a\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006D"}, d2={"Lio/realm/kotlin/internal/ManagedRealmSet;", "E", "Lkotlin/collections/AbstractMutableSet;", "Lio/realm/kotlin/types/RealmSet;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/CoreNotifiable;", "Lio/realm/kotlin/notifications/SetChange;", "Lio/realm/kotlin/Versioned;", "parent", "Lio/realm/kotlin/internal/RealmObjectReference;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSetT;", "Lio/realm/kotlin/internal/interop/RealmSetPointer;", "operator", "Lio/realm/kotlin/internal/SetOperator;", "<init>", "(Lio/realm/kotlin/internal/RealmObjectReference;Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/SetOperator;)V", "getParent$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/RealmObjectReference;", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOperator", "()Lio/realm/kotlin/internal/SetOperator;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "clear", "", "contains", "remove", "removeAll", "elements", "", "iterator", "", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "keyPaths", "", "", "freeze", "frozenRealm", "Lio/realm/kotlin/internal/RealmReference;", "thaw", "liveRealm", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "Lio/realm/kotlin/internal/interop/RealmKeyPathArrayT;", "Lio/realm/kotlin/internal/interop/RealmKeyPathArrayPointer;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "changeFlow", "Lio/realm/kotlin/internal/ChangeFlow;", "scope", "Lkotlinx/coroutines/channels/ProducerScope;", "delete", "isValid", "version", "Lio/realm/kotlin/VersionId;", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nRealmSetInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmSetInternal.kt\nio/realm/kotlin/internal/ManagedRealmSet\n+ 2 Validation.kt\nio/realm/kotlin/internal/util/Validation\n*L\n1#1,564:1\n45#2,4:565\n*S KotlinDebug\n*F\n+ 1 RealmSetInternal.kt\nio/realm/kotlin/internal/ManagedRealmSet\n*L\n173#1:565,4\n*E\n"})
public final class ManagedRealmSet<E>
extends AbstractMutableSet<E>
implements RealmSet<E>,
InternalDeleteable,
CoreNotifiable<ManagedRealmSet<E>, SetChange<E>>,
Versioned {
    private final /* synthetic */ RealmReference $$delegate_0;
    @Nullable
    private final RealmObjectReference<?> parent;
    @NotNull
    private final NativePointer<RealmSetT> nativePointer;
    @NotNull
    private final SetOperator<E> operator;

    public ManagedRealmSet(@Nullable RealmObjectReference<?> parent, @NotNull NativePointer<RealmSetT> nativePointer, @NotNull SetOperator<E> operator) {
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.$$delegate_0 = operator.getRealmReference();
        this.parent = parent;
        this.nativePointer = nativePointer;
        this.operator = operator;
    }

    @Nullable
    public final RealmObjectReference<?> getParent$io_realm_kotlin_library() {
        return this.parent;
    }

    @NotNull
    public final NativePointer<RealmSetT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @NotNull
    public final SetOperator<E> getOperator() {
        return this.operator;
    }

    public int getSize() {
        this.operator.getRealmReference().checkClosed();
        return (int)RealmInterop.INSTANCE.realm_set_size(this.nativePointer);
    }

    @Override
    public boolean add(E element) {
        return SetOperator.DefaultImpls.add$default(this.operator, element, null, null, 6, null);
    }

    @Override
    public void clear() {
        this.operator.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.operator.contains(element);
    }

    @Override
    public boolean remove(Object element) {
        return this.operator.remove(element);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.operator.removeAll(elements);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(this){
            private int expectedModCount;
            private int cursor;
            private int lastReturned;
            final /* synthetic */ ManagedRealmSet<E> this$0;
            {
                this.this$0 = $receiver;
                this.expectedModCount = $receiver.getOperator().getModCount();
                this.lastReturned = -1;
            }

            public boolean hasNext() {
                this.checkConcurrentModification();
                return this.cursor < this.this$0.size();
            }

            public E next() {
                this.checkConcurrentModification();
                int position = this.cursor;
                if (position >= this.this$0.size()) {
                    throw new IndexOutOfBoundsException("Cannot access index " + position + " when size is " + this.this$0.size() + ". Remember to check hasNext() before using next().");
                }
                E next = this.this$0.getOperator().get(position);
                this.lastReturned = position;
                this.cursor = position + 1;
                return next;
            }

            public void remove() {
                boolean bl;
                this.checkConcurrentModification();
                if (this.this$0.size() == 0) {
                    throw new NoSuchElementException("Could not remove last element returned by the iterator: set is empty.");
                }
                if (this.lastReturned < 0) {
                    throw new IllegalStateException("Could not remove last element returned by the iterator: iterator never returned an element.");
                }
                ManagedRealmSet<E> managedRealmSet = this.this$0;
                boolean $i$f$getterScope = false;
                boolean $i$f$realmValueAllocator = false;
                MemAllocator $this$remove_u24lambda_u241 = (MemAllocator)JvmMemAllocator.INSTANCE;
                boolean bl2 = false;
                E element = managedRealmSet.getOperator().get(this.lastReturned);
                boolean it = bl = managedRealmSet.getOperator().remove(element);
                boolean bl3 = false;
                if (this.lastReturned < this.cursor) {
                    --this.cursor;
                }
                this.lastReturned = -1;
                boolean erased = bl;
                this.expectedModCount = this.this$0.getOperator().getModCount();
                if (!erased) {
                    throw new NoSuchElementException("Could not remove last element returned by the iterator: was there an element to remove?");
                }
            }

            private final void checkConcurrentModification() {
                if (this.this$0.getOperator().getModCount() != this.expectedModCount) {
                    throw new ConcurrentModificationException("The underlying RealmSet was modified while iterating it.");
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flow<SetChange<E>> asFlow(@Nullable List<String> keyPaths) {
        Pair pair;
        List<String> list = keyPaths;
        if (list != null) {
            void arg$iv;
            List<String> it = list;
            boolean bl = false;
            Validation validation = Validation.INSTANCE;
            SetOperator<E> setOperator = this.operator;
            String errorMessage$iv = "Keypaths are only supported for sets of objects.";
            boolean $i$f$isType = false;
            if (!(arg$iv instanceof RealmObjectSetOperator)) {
                throw new IllegalArgumentException(errorMessage$iv);
            }
            pair = new Pair((Object)ClassKey.box-impl((long)((RealmObjectSetOperator)this.operator).getClassKey-QNRHIEo()), keyPaths);
        } else {
            pair = null;
        }
        Pair keyPathInfo = pair;
        return this.operator.getRealmReference().getOwner().registerObserver$io_realm_kotlin_library(this, keyPathInfo);
    }

    @Override
    @Nullable
    public ManagedRealmSet<E> freeze(@NotNull RealmReference frozenRealm) {
        ManagedRealmSet<E> managedRealmSet;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_set_resolve_in(this.nativePointer, frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmSet = new ManagedRealmSet<E>(this.parent, (NativePointer<RealmSetT>)it, this.operator.copy(frozenRealm, (NativePointer<RealmSetT>)it));
        } else {
            managedRealmSet = null;
        }
        return managedRealmSet;
    }

    @Override
    @Nullable
    public ManagedRealmSet<E> thaw(@NotNull RealmReference liveRealm) {
        ManagedRealmSet<E> managedRealmSet;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_set_resolve_in(this.nativePointer, liveRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmSet = new ManagedRealmSet<E>(this.parent, (NativePointer<RealmSetT>)it, this.operator.copy(liveRealm, (NativePointer<RealmSetT>)it));
        } else {
            managedRealmSet = null;
        }
        return managedRealmSet;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@Nullable NativePointer<RealmKeyPathArrayT> keyPaths, @NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_set_add_notification_callback(this.nativePointer, keyPaths, callback);
    }

    @Override
    @NotNull
    public ChangeFlow<ManagedRealmSet<E>, SetChange<E>> changeFlow(@NotNull ProducerScope<? super SetChange<E>> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        return new RealmSetChangeFlow(scope);
    }

    @Override
    public void delete() {
        RealmInterop.INSTANCE.realm_set_remove_all(this.nativePointer);
    }

    @Override
    public boolean isValid() {
        return !this.nativePointer.isReleased() && RealmInterop.INSTANCE.realm_set_is_valid(this.nativePointer);
    }

    @Override
    @NotNull
    public Notifiable<ManagedRealmSet<E>, SetChange<E>> notifiable() {
        return CoreNotifiable.DefaultImpls.notifiable(this);
    }

    @Override
    @Nullable
    public CoreNotifiable<ManagedRealmSet<E>, SetChange<E>> coreObservable(@NotNull LiveRealm liveRealm) {
        return CoreNotifiable.DefaultImpls.coreObservable(this, liveRealm);
    }

    @Override
    @NotNull
    public VersionId version() {
        return this.$$delegate_0.version();
    }
}

