/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.predicate;

import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.transport.api.ConnectionContext;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Predicates {
    private Predicates() {
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> method(HttpRequestMethod method) {
        Objects.requireNonNull(method);
        return (ctx, req) -> req.method().equals((Object)method);
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> methodIsOneOf(HttpRequestMethod ... methods) {
        return Predicates.orBiPredicates(Stream.of(methods).map(Predicates::method).collect(Collectors.toList()));
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> pathEquals(String path) {
        Objects.requireNonNull(path);
        return (ctx, req) -> req.path().equals(path);
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> pathIsOneOf(String ... paths) {
        return Predicates.orBiPredicates(Stream.of(paths).map(Predicates::pathEquals).collect(Collectors.toList()));
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> pathStartsWith(String pathPrefix) {
        Objects.requireNonNull(pathPrefix);
        return (ctx, req) -> req.path().startsWith(pathPrefix);
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> pathRegex(String regex) {
        Predicate<CharSequence> regexPredicate = Predicates.regex(regex);
        return (ctx, req) -> regexPredicate.test(req.path());
    }

    static BiPredicate<ConnectionContext, StreamingHttpRequest> pathRegex(Pattern regex) {
        Predicate<CharSequence> regexPredicate = Predicates.regex(regex);
        return (ctx, req) -> regexPredicate.test(req.path());
    }

    static Predicate<CharSequence> regex(String regex) {
        return Predicates.regex(Pattern.compile(regex));
    }

    static Predicate<CharSequence> regex(Pattern pattern) {
        return value -> pattern.matcher((CharSequence)value).matches();
    }

    static <T, U> BiPredicate<T, U> orBiPredicates(Iterable<BiPredicate<T, U>> predicates) {
        Iterator<BiPredicate<T, U>> iterator = predicates.iterator();
        if (!iterator.hasNext()) {
            return (ctx, req) -> true;
        }
        BiPredicate<T, U> predicate = iterator.next();
        while (iterator.hasNext()) {
            predicate = predicate.or(iterator.next());
        }
        return predicate;
    }
}

