/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.saga.action.http;

import io.simplesource.data.Result;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class HttpRequest<K, B> {
    public final K key;
    public final HttpVerb verb;
    public final String url;
    public final Map<String, String> headers;
    public final Optional<B> body;
    public final Optional<String> topicName;

    public static <K> HttpRequest<K, ?> of(K key, HttpVerb verb, String url) {
        return new HttpRequest(key, verb, url, Collections.emptyMap(), Optional.empty(), Optional.empty());
    }

    public static <K> HttpRequest<K, ?> of(K key, HttpVerb verb, String url, String topicName) {
        return new HttpRequest(key, verb, url, Collections.emptyMap(), Optional.empty(), Optional.ofNullable(topicName));
    }

    public static <K, B> HttpRequest<K, B> ofWithBody(K key, HttpVerb verb, String url, String topicName, B body) {
        return new HttpRequest<K, B>(key, verb, url, Collections.emptyMap(), Optional.ofNullable(body), Optional.ofNullable(topicName));
    }

    public HttpRequest(K key, HttpVerb verb, String url, Map<String, String> headers, Optional<B> body, Optional<String> topicName) {
        this.key = key;
        this.verb = verb;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.topicName = topicName;
    }

    public K key() {
        return this.key;
    }

    public HttpVerb verb() {
        return this.verb;
    }

    public String url() {
        return this.url;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Optional<B> body() {
        return this.body;
    }

    public Optional<String> topicName() {
        return this.topicName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        K this$key = this.key();
        K other$key = other.key();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        HttpVerb this$verb = this.verb();
        HttpVerb other$verb = other.verb();
        if (this$verb == null ? other$verb != null : !((Object)((Object)this$verb)).equals((Object)other$verb)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, String> this$headers = this.headers();
        Map<String, String> other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Optional<B> this$body = this.body();
        Optional<B> other$body = other.body();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Optional<String> this$topicName = this.topicName();
        Optional<String> other$topicName = other.topicName();
        return !(this$topicName == null ? other$topicName != null : !((Object)this$topicName).equals(other$topicName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.key();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        HttpVerb $verb = this.verb();
        result = result * 59 + ($verb == null ? 43 : ((Object)((Object)$verb)).hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, String> $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Optional<B> $body = this.body();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Optional<String> $topicName = this.topicName();
        result = result * 59 + ($topicName == null ? 43 : ((Object)$topicName).hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequest(key=" + this.key() + ", verb=" + (Object)((Object)this.verb()) + ", url=" + this.url() + ", headers=" + this.headers() + ", body=" + this.body() + ", topicName=" + this.topicName() + ")";
    }

    public static enum HttpVerb {
        Get,
        Post,
        Put,
        Delete;

    }

    public static interface HttpRequestDecoder<A, K, B> {
        public Result<Throwable, HttpRequest<K, B>> decode(A var1);
    }
}

