/*
 * Decompiled with CFR 0.152.
 */
package spray.servlet;

import akka.event.LoggingAdapter;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.http.ContentType;
import spray.http.ErrorInfo;
import spray.http.ErrorInfo$;
import spray.http.HttpEntity;
import spray.http.HttpEntity$;
import spray.http.HttpHeader;
import spray.http.HttpHeaders;
import spray.http.HttpMethod;
import spray.http.HttpMethods$;
import spray.http.HttpProtocol;
import spray.http.HttpProtocols$;
import spray.http.HttpRequest;
import spray.http.IllegalRequestException;
import spray.http.IllegalUriException;
import spray.http.RequestProcessingException;
import spray.http.StatusCodes$;
import spray.http.Uri;
import spray.http.Uri$;
import spray.http.parser.HttpParser$;
import spray.http.parser.ParserInput$;
import spray.servlet.ConnectorSettings;
import spray.servlet.ServletRequestInfoHeader;
import spray.util.package$;

public final class ModelConverter$ {
    public static final ModelConverter$ MODULE$;

    static {
        new ModelConverter$();
    }

    public HttpRequest toHttpRequest(HttpServletRequest hsRequest, ConnectorSettings settings, LoggingAdapter log) {
        Tuple2 tuple2 = HttpParser$.MODULE$.parseHeaders(this.rawHeaders(hsRequest), HttpParser$.MODULE$.parseHeaders$default$2(), HttpParser$.MODULE$.parseHeaders$default$3());
        if (tuple2 != null) {
            Tuple2 tuple22;
            List errors = (List)tuple2._1();
            List parsedHeaders = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)errors, (Object)parsedHeaders);
            List errors2 = (List)tuple23._1();
            List parsedHeaders2 = (List)tuple23._2();
            if (errors2.nonEmpty() && settings.illegalHeaderWarnings()) {
                errors2.foreach((Function1)new Serializable(log){
                    public static final long serialVersionUID = 0L;
                    private final LoggingAdapter log$1;

                    public final void apply(ErrorInfo e) {
                        this.log$1.warning(e.formatPretty());
                    }
                    {
                        this.log$1 = log$1;
                    }
                });
            }
            Option contentType = parsedHeaders2.collectFirst((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends HttpHeader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof HttpHeaders.Content$minusType) {
                        HttpHeaders.Content$minusType content$minusType = (HttpHeaders.Content$minusType)A1;
                        ContentType ct = content$minusType.contentType();
                        object = ct;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(HttpHeader x1) {
                    HttpHeader httpHeader = x1;
                    boolean bl = httpHeader instanceof HttpHeaders.Content$minusType;
                    return bl;
                }
            });
            return new HttpRequest(this.toHttpMethod(hsRequest.getMethod()), this.rebuildUri(hsRequest, settings, log), this.addOptionalHeaders(hsRequest, (List<HttpHeader>)parsedHeaders2, settings), this.toHttpEntity(hsRequest, (Option<ContentType>)contentType, hsRequest.getContentLength(), settings, log), this.toHttpProtocol(hsRequest.getProtocol()));
        }
        throw new MatchError((Object)tuple2);
    }

    public List<HttpHeaders.RawHeader> rawHeaders(HttpServletRequest hsRequest) {
        return this.rec$1(hsRequest.getHeaderNames(), this.rec$default$2$1(), hsRequest);
    }

    public HttpMethod toHttpMethod(String name) {
        return (HttpMethod)HttpMethods$.MODULE$.getForKey((Object)name).getOrElse((Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Nothing$ apply() {
                throw new IllegalRequestException(StatusCodes$.MODULE$.MethodNotAllowed(), new ErrorInfo("Illegal HTTP method", this.name$1));
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public Uri rebuildUri(HttpServletRequest hsRequest, ConnectorSettings settings, LoggingAdapter log) {
        StringBuffer buffer = this.addQueryString(hsRequest, hsRequest.getRequestURL());
        try {
            Uri uri;
            Uri uri2 = Uri$.MODULE$.apply(ParserInput$.MODULE$.apply(buffer.toString()), settings.uriParsingMode());
            if (settings.rootPath().isEmpty()) {
                uri = uri2;
            } else if (uri2.path().startsWith(settings.rootPath())) {
                Uri.Path x$5 = uri2.path().dropChars(settings.rootPathCharCount());
                String x$6 = uri2.copy$default$1();
                Uri.Authority x$7 = uri2.copy$default$2();
                Uri.Query x$8 = uri2.copy$default$4();
                Option x$9 = uri2.copy$default$5();
                uri = uri2.copy(x$6, x$7, x$5, x$8, x$9);
            } else {
                log.warning("Received request outside of configured root-path, request uri '{}', configured root path '{}'", (Object)uri2, (Object)settings.rootPath());
                uri = uri2;
            }
            return uri;
        }
        catch (IllegalUriException illegalUriException) {
            throw new IllegalRequestException(StatusCodes$.MODULE$.BadRequest(), new ErrorInfo("Illegal request URI", illegalUriException.getMessage()));
        }
    }

    private <A extends Appendable> A addQueryString(HttpServletRequest hsr, A buffer) {
        String string = hsr.getQueryString();
        Object object = string == null ? BoxedUnit.UNIT : buffer.append('?').append(string);
        return buffer;
    }

    public List<HttpHeader> addOptionalHeaders(HttpServletRequest hsr, List<HttpHeader> originalHeaders, ConnectorSettings settings) {
        List headers = originalHeaders;
        if (settings.servletRequestAccess()) {
            ServletRequestInfoHeader servletRequestInfoHeader = new ServletRequestInfoHeader(hsr);
            headers = headers.$colon$colon((Object)servletRequestInfoHeader);
        }
        if (settings.remoteAddressHeader()) {
            HttpHeaders.Remote$minusAddress remote$minusAddress = HttpHeaders.Remote$minusAddress$.MODULE$.apply(hsr.getRemoteAddr());
            headers = headers.$colon$colon((Object)remote$minusAddress);
        }
        return headers;
    }

    public HttpProtocol toHttpProtocol(String name) {
        return (HttpProtocol)HttpProtocols$.MODULE$.getForKey((Object)name).getOrElse((Function0)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final Nothing$ apply() {
                throw new IllegalRequestException(StatusCodes$.MODULE$.BadRequest(), new ErrorInfo("Illegal HTTP protocol", this.name$2));
            }
            {
                this.name$2 = name$2;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpEntity toHttpEntity(HttpServletRequest hsRequest, Option<ContentType> contentType, int contentLength, ConnectorSettings settings, LoggingAdapter log) {
        HttpEntity httpEntity;
        byte[] body;
        byte[] byArray;
        if (contentLength > 0) {
            if ((long)contentLength > settings.maxContentLength()) throw new IllegalRequestException(StatusCodes$.MODULE$.RequestEntityTooLarge(), new ErrorInfo(new StringBuilder().append((Object)"HTTP message Content-Length ").append((Object)BoxesRunTime.boxToInteger((int)contentLength)).append((Object)" exceeds the configured limit of ").append((Object)BoxesRunTime.boxToLong((long)settings.maxContentLength())).toString(), ErrorInfo$.MODULE$.apply$default$2()));
            try {
                byArray = this.drainRequestInputStream$1(new byte[contentLength], hsRequest.getInputStream(), this.drainRequestInputStream$default$3$1(), contentLength);
            }
            catch (IOException iOException) {
                log.error((Throwable)iOException, "Could not read request entity");
                throw new RequestProcessingException(StatusCodes$.MODULE$.InternalServerError(), "Could not read request entity");
            }
        } else {
            byArray = body = package$.MODULE$.EmptyByteArray();
        }
        if (contentType.isEmpty()) {
            httpEntity = HttpEntity$.MODULE$.apply(body);
            return httpEntity;
        }
        httpEntity = HttpEntity$.MODULE$.apply((ContentType)contentType.get(), body);
        return httpEntity;
    }

    private final String concatValues$1(Enumeration values, java.lang.StringBuilder sb) {
        while (values.hasMoreElements()) {
            sb = sb.length() == 0 ? sb.append((String)values.nextElement()) : sb.append(", ").append((String)values.nextElement());
        }
        return sb.toString();
    }

    private final List rec$1(Enumeration names, List headers, HttpServletRequest hsRequest$1) {
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            HttpHeaders.RawHeader rawHeader = new HttpHeaders.RawHeader(name, this.concatValues$1(hsRequest$1.getHeaders(name), new java.lang.StringBuilder()));
            headers = headers.$colon$colon((Object)rawHeader);
        }
        return headers;
    }

    private final List rec$default$2$1() {
        return Nil$.MODULE$;
    }

    private final byte[] drainRequestInputStream$1(byte[] buf, ServletInputStream inputStream, int bytesRead, int contentLength$1) {
        while (bytesRead < contentLength$1) {
            int count = inputStream.read(buf, bytesRead, contentLength$1 - bytesRead);
            if (count >= 0) {
                bytesRead += count;
                continue;
            }
            throw new RequestProcessingException(StatusCodes$.MODULE$.InternalServerError(), new StringBuilder().append((Object)"Illegal Servlet request entity, expected length ").append((Object)BoxesRunTime.boxToInteger((int)contentLength$1)).append((Object)" but only has length ").append((Object)BoxesRunTime.boxToInteger((int)bytesRead)).toString());
        }
        return buf;
    }

    private final int drainRequestInputStream$default$3$1() {
        return 0;
    }

    private ModelConverter$() {
        MODULE$ = this;
    }
}

