/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem;

import io.spring.initializr.generator.buildsystem.BomContainer;
import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.BuildSettings;
import io.spring.initializr.generator.buildsystem.DependencyContainer;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.MavenRepositoryContainer;
import io.spring.initializr.generator.buildsystem.PropertyContainer;
import io.spring.initializr.generator.buildsystem.SimpleBuildItemResolver;

public abstract class Build {
    private final PropertyContainer properties;
    private final DependencyContainer dependencies;
    private final BomContainer boms;
    private final MavenRepositoryContainer repositories;
    private final MavenRepositoryContainer pluginRepositories;

    protected Build(BuildItemResolver buildItemResolver) {
        BuildItemResolver resolver = Build.determineBuildItemResolver(buildItemResolver);
        this.properties = new PropertyContainer();
        this.dependencies = new DependencyContainer(resolver::resolveDependency);
        this.boms = new BomContainer(resolver::resolveBom);
        this.repositories = new MavenRepositoryContainer(resolver::resolveRepository);
        this.pluginRepositories = new MavenRepositoryContainer(resolver::resolveRepository);
    }

    protected static BuildItemResolver determineBuildItemResolver(BuildItemResolver buildItemResolver) {
        if (buildItemResolver != null) {
            return buildItemResolver;
        }
        return new SimpleBuildItemResolver(id -> null, id -> null, id -> id.equals("maven-central") ? MavenRepository.MAVEN_CENTRAL : null);
    }

    public abstract BuildSettings.Builder<?> settings();

    public abstract BuildSettings getSettings();

    public PropertyContainer properties() {
        return this.properties;
    }

    public DependencyContainer dependencies() {
        return this.dependencies;
    }

    public BomContainer boms() {
        return this.boms;
    }

    public MavenRepositoryContainer repositories() {
        return this.repositories;
    }

    public MavenRepositoryContainer pluginRepositories() {
        return this.pluginRepositories;
    }
}

