/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.BillOfMaterials;
import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.DependencyComparator;
import io.spring.initializr.generator.buildsystem.DependencyContainer;
import io.spring.initializr.generator.buildsystem.DependencyScope;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.PropertyContainer;
import io.spring.initializr.generator.buildsystem.gradle.Attribute;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildSettings;
import io.spring.initializr.generator.buildsystem.gradle.GradleConfigurationContainer;
import io.spring.initializr.generator.buildsystem.gradle.GradleDependency;
import io.spring.initializr.generator.buildsystem.gradle.GradleExtension;
import io.spring.initializr.generator.buildsystem.gradle.GradleExtensionContainer;
import io.spring.initializr.generator.buildsystem.gradle.GradleSnippetContainer;
import io.spring.initializr.generator.buildsystem.gradle.GradleTask;
import io.spring.initializr.generator.buildsystem.gradle.GradleTaskContainer;
import io.spring.initializr.generator.buildsystem.gradle.Invocation;
import io.spring.initializr.generator.buildsystem.gradle.StandardGradlePlugin;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.version.VersionProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GradleBuildWriter {
    public final void writeTo(IndentingWriter writer, GradleBuild build) {
        GradleBuildSettings settings = build.getSettings();
        this.writeImports(writer, build.tasks(), build.snippets(), build.extensions());
        this.writeBuildscript(writer, build);
        this.writePlugins(writer, build);
        this.writeProperty(writer, "group", settings.getGroup());
        this.writeProperty(writer, "version", settings.getVersion());
        writer.println();
        this.writeJavaSourceCompatibility(writer, settings);
        this.writeToolchain(writer, settings);
        this.writeConfigurations(writer, build.configurations());
        this.writeRepositories(writer, build);
        this.writeProperties(writer, build.properties());
        this.writeDependencies(writer, build);
        this.writeBoms(writer, build);
        this.writeExtensions(writer, build.extensions());
        this.writeTasks(writer, build.tasks());
        this.writeSnippets(writer, build.snippets());
    }

    private void writeImports(IndentingWriter writer, GradleTaskContainer tasks, GradleSnippetContainer snippets, GradleExtensionContainer extensions) {
        List<String> imports = GradleBuildWriter.concat(tasks.importedTypes(), snippets.importedTypes(), extensions.importedTypes()).sorted().toList();
        imports.forEach(importedType -> writer.println("import " + importedType));
        if (!imports.isEmpty()) {
            writer.println();
        }
    }

    protected abstract void writeBuildscript(IndentingWriter var1, GradleBuild var2);

    protected abstract void writePlugins(IndentingWriter var1, GradleBuild var2);

    protected List<StandardGradlePlugin> extractStandardPlugin(GradleBuild build) {
        return build.plugins().values().filter(StandardGradlePlugin.class::isInstance).map(StandardGradlePlugin.class::cast).collect(Collectors.toList());
    }

    @Deprecated(forRemoval=true)
    protected void writeJavaSourceCompatibility(IndentingWriter writer, GradleBuildSettings settings) {
    }

    protected abstract void writeConfigurations(IndentingWriter var1, GradleConfigurationContainer var2);

    private void writeToolchain(IndentingWriter writer, GradleBuildSettings settings) {
        writer.println("java {");
        writer.indented(() -> {
            writer.println("toolchain {");
            writer.indented(() -> writer.println("languageVersion = JavaLanguageVersion.of(%s)".formatted(GradleBuildWriter.sourceCompatibilityAsNumber(settings))));
            writer.println("}");
        });
        writer.println("}");
        writer.println("");
    }

    private static String sourceCompatibilityAsNumber(GradleBuildSettings settings) {
        String version;
        String string = version = settings.getSourceCompatibility() != null ? settings.getSourceCompatibility() : "1.8";
        if (version.startsWith("1.")) {
            return version.substring("1.".length());
        }
        return version;
    }

    protected final void writeRepositories(IndentingWriter writer, GradleBuild build) {
        this.writeNestedCollection(writer, "repositories", build.repositories().items().collect(Collectors.toList()), this::repositoryAsString);
    }

    protected abstract String repositoryAsString(MavenRepository var1);

    private void writeProperties(IndentingWriter writer, PropertyContainer properties) {
        if (properties.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> allProperties = new LinkedHashMap<String, String>(properties.values().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, TreeMap::new)));
        properties.versions(this::getVersionPropertyKey).forEach(entry -> allProperties.put((String)entry.getKey(), "\"" + (String)entry.getValue() + "\""));
        this.writeExtraProperties(writer, allProperties);
    }

    protected abstract void writeExtraProperties(IndentingWriter var1, Map<String, String> var2);

    private String getVersionPropertyKey(VersionProperty versionProperty) {
        return versionProperty.isInternal() ? versionProperty.toCamelCaseFormat() : versionProperty.toStandardFormat();
    }

    private void writeDependencies(IndentingWriter writer, GradleBuild build) {
        LinkedHashSet<Dependency> sortedDependencies = new LinkedHashSet<Dependency>();
        DependencyContainer dependencies = build.dependencies();
        sortedDependencies.addAll(this.filterDependencies(dependencies, scope -> scope == null || scope == DependencyScope.COMPILE));
        sortedDependencies.addAll(this.filterDependencies(dependencies, this.hasScope(DependencyScope.COMPILE_ONLY)));
        sortedDependencies.addAll(this.filterDependencies(dependencies, this.hasScope(DependencyScope.RUNTIME)));
        sortedDependencies.addAll(this.filterDependencies(dependencies, this.hasScope(DependencyScope.ANNOTATION_PROCESSOR)));
        sortedDependencies.addAll(this.filterDependencies(dependencies, this.hasScope(DependencyScope.PROVIDED_RUNTIME)));
        sortedDependencies.addAll(this.filterDependencies(dependencies, this.hasScope(DependencyScope.TEST_COMPILE)));
        sortedDependencies.addAll(this.filterDependencies(dependencies, this.hasScope(DependencyScope.TEST_RUNTIME)));
        if (!sortedDependencies.isEmpty()) {
            writer.println();
            writer.println("dependencies {");
            writer.indented(() -> sortedDependencies.forEach(dependency -> this.writeDependency(writer, (Dependency)dependency)));
            writer.println("}");
        }
    }

    private Predicate<DependencyScope> hasScope(DependencyScope ... validScopes) {
        return scope -> Arrays.asList(validScopes).contains(scope);
    }

    protected Comparator<Dependency> getDependencyComparator() {
        return DependencyComparator.INSTANCE;
    }

    protected abstract void writeDependency(IndentingWriter var1, Dependency var2);

    protected String configurationForDependency(Dependency dependency) {
        String configuration;
        if (dependency instanceof GradleDependency && (configuration = ((GradleDependency)dependency).getConfiguration()) != null) {
            return configuration;
        }
        DependencyScope type = dependency.getScope();
        if (type == null) {
            return "implementation";
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DependencyScope.ANNOTATION_PROCESSOR -> "annotationProcessor";
            case DependencyScope.COMPILE -> "implementation";
            case DependencyScope.COMPILE_ONLY -> "compileOnly";
            case DependencyScope.PROVIDED_RUNTIME -> "providedRuntime";
            case DependencyScope.RUNTIME -> "runtimeOnly";
            case DependencyScope.TEST_COMPILE -> "testImplementation";
            case DependencyScope.TEST_RUNTIME -> "testRuntimeOnly";
        };
    }

    private void writeBoms(IndentingWriter writer, GradleBuild build) {
        if (build.boms().isEmpty()) {
            return;
        }
        List boms = build.boms().items().sorted(Comparator.comparingInt(BillOfMaterials::getOrder).reversed()).collect(Collectors.toList());
        writer.println();
        writer.println("dependencyManagement {");
        writer.indented(() -> this.writeNestedCollection(writer, "imports", boms, this::bomAsString));
        writer.println("}");
    }

    protected abstract String bomAsString(BillOfMaterials var1);

    protected abstract void writeTasks(IndentingWriter var1, GradleTaskContainer var2);

    private void writeExtensions(IndentingWriter writer, GradleExtensionContainer extensions) {
        extensions.values().forEach(extension -> {
            writer.println();
            writer.println(extension.getName() + " {");
            writer.indented(() -> this.writeExtensionCustomization(writer, (GradleExtension)extension));
            writer.println("}");
        });
    }

    private void writeExtensionCustomization(IndentingWriter writer, GradleExtension extension) {
        this.writeCollection(writer, extension.getInvocations(), this::invocationAsString);
        this.writeCollection(writer, extension.getAttributes(), this::attributeAsString);
        extension.getNested().forEach((ignored, nested) -> {
            writer.println(nested.getName() + " {");
            writer.indented(() -> this.writeExtensionCustomization(writer, (GradleExtension)nested));
            writer.println("}");
        });
    }

    protected final void writeTaskCustomization(IndentingWriter writer, GradleTask task) {
        this.writeCollection(writer, task.getInvocations(), this::invocationAsString);
        this.writeCollection(writer, task.getAttributes(), this::attributeAsString);
        task.getNested().forEach((property, nestedCustomization) -> {
            writer.println(property + " {");
            writer.indented(() -> this.writeTaskCustomization(writer, (GradleTask)nestedCustomization));
            writer.println("}");
        });
    }

    private String attributeAsString(Attribute attribute) {
        String separator = attribute.getType() == Attribute.Type.SET ? "=" : "+=";
        return String.format("%s %s %s", attribute.getName(), separator, attribute.getValue());
    }

    protected abstract String invocationAsString(Invocation var1);

    private void writeSnippets(IndentingWriter writer, GradleSnippetContainer snippets) {
        if (!snippets.isEmpty()) {
            writer.println();
        }
        snippets.values().forEach(snippet -> {
            snippet.apply(writer);
            writer.println();
        });
    }

    protected final <T> void writeNestedCollection(IndentingWriter writer, String name, Collection<T> collection, Function<T, String> itemToStringConverter) {
        this.writeNestedCollection(writer, name, collection, itemToStringConverter, null);
    }

    protected final <T> void writeNestedCollection(IndentingWriter writer, String name, Collection<T> collection, Function<T, String> converter, Runnable beforeWriting) {
        if (!collection.isEmpty()) {
            if (beforeWriting != null) {
                beforeWriting.run();
            }
            writer.println(name + " {");
            writer.indented(() -> this.writeCollection(writer, collection, converter));
            writer.println("}");
        }
    }

    protected final <T> void writeCollection(IndentingWriter writer, Collection<T> collection, Function<T, String> converter) {
        this.writeCollection(writer, collection, converter, null);
    }

    protected final <T> void writeCollection(IndentingWriter writer, Collection<T> collection, Function<T, String> itemToStringConverter, Runnable beforeWriting) {
        if (!collection.isEmpty()) {
            if (beforeWriting != null) {
                beforeWriting.run();
            }
            collection.stream().map(itemToStringConverter).forEach(writer::println);
        }
    }

    protected final <T, U> void writeMap(IndentingWriter writer, Map<T, U> map, BiFunction<T, U, String> converter) {
        map.forEach((key, value) -> writer.println((String)converter.apply(key, value)));
    }

    protected abstract void writeProperty(IndentingWriter var1, String var2, String var3);

    private Collection<Dependency> filterDependencies(DependencyContainer dependencies, Predicate<DependencyScope> filter) {
        return dependencies.items().filter(dep -> filter.test(dep.getScope())).sorted(this.getDependencyComparator()).collect(Collectors.toList());
    }

    @SafeVarargs
    private static Stream<String> concat(Stream<String> ... streams) {
        Stream<String> result = Stream.empty();
        for (Stream<String> stream : streams) {
            result = Stream.concat(result, stream);
        }
        return result;
    }
}

