/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class MavenPlugin {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final boolean extensions;
    private final List<Execution> executions;
    private final List<Dependency> dependencies;
    private final Configuration configuration;

    protected MavenPlugin(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        this.extensions = builder.extensions;
        this.executions = builder.executions.values().stream().map(ExecutionBuilder::build).toList();
        this.dependencies = List.copyOf(builder.dependencies);
        this.configuration = builder.configurationBuilder == null ? null : builder.configurationBuilder.build();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isExtensions() {
        return this.extensions;
    }

    public List<Execution> getExecutions() {
        return this.executions;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static class Builder {
        private final String groupId;
        private final String artifactId;
        private String version;
        private boolean extensions;
        private final Map<String, ExecutionBuilder> executions = new LinkedHashMap<String, ExecutionBuilder>();
        private final List<Dependency> dependencies = new ArrayList<Dependency>();
        private ConfigurationBuilder configurationBuilder;

        protected Builder(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder extensions(boolean extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder configuration(Consumer<ConfigurationBuilder> configuration) {
            if (this.configurationBuilder == null) {
                this.configurationBuilder = new ConfigurationBuilder();
            }
            configuration.accept(this.configurationBuilder);
            return this;
        }

        public Builder execution(String id, Consumer<ExecutionBuilder> execution) {
            execution.accept(this.executions.computeIfAbsent(id, key -> new ExecutionBuilder(id)));
            return this;
        }

        public Builder dependency(String groupId, String artifactId, String version) {
            this.dependencies.add(new Dependency(groupId, artifactId, version));
            return this;
        }

        public MavenPlugin build() {
            return new MavenPlugin(this);
        }
    }

    public static class ConfigurationBuilder {
        private final List<Setting> settings = new ArrayList<Setting>();

        public ConfigurationBuilder add(String name, String value) {
            this.settings.add(new Setting(name, value));
            return this;
        }

        public ConfigurationBuilder add(String name, Consumer<ConfigurationBuilder> consumer) {
            ConfigurationBuilder nestedConfiguration = new ConfigurationBuilder();
            consumer.accept(nestedConfiguration);
            this.settings.add(new Setting(name, nestedConfiguration));
            return this;
        }

        public ConfigurationBuilder configure(String name, Consumer<ConfigurationBuilder> consumer) {
            Object value = this.settings.stream().filter(candidate -> candidate.getName().equals(name)).findFirst().orElseGet(() -> {
                Setting nestedSetting = new Setting(name, new ConfigurationBuilder());
                this.settings.add(nestedSetting);
                return nestedSetting;
            }).getValue();
            if (!(value instanceof ConfigurationBuilder)) {
                throw new IllegalArgumentException(String.format("Could not customize parameter '%s', a single value %s is already registered", name, value));
            }
            ConfigurationBuilder nestedConfiguration = (ConfigurationBuilder)value;
            consumer.accept(nestedConfiguration);
            return this;
        }

        Configuration build() {
            return new Configuration(this.settings.stream().map(entry -> this.resolve(entry.getName(), entry.getValue())).toList());
        }

        private Setting resolve(String key, Object value) {
            if (value instanceof ConfigurationBuilder) {
                ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)value;
                List<Setting> values = configurationBuilder.settings.stream().map(entry -> this.resolve(entry.getName(), entry.getValue())).toList();
                return new Setting(key, values);
            }
            return new Setting(key, value);
        }
    }

    public static final class Configuration {
        private final List<Setting> settings;

        private Configuration(List<Setting> settings) {
            this.settings = List.copyOf(settings);
        }

        public List<Setting> getSettings() {
            return this.settings;
        }
    }

    public static final class Dependency {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private Dependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static final class Execution {
        private final String id;
        private final String phase;
        private final List<String> goals;
        private final Configuration configuration;

        private Execution(String id, String phase, List<String> goals, Configuration configuration) {
            this.id = id;
            this.phase = phase;
            this.goals = Collections.unmodifiableList(goals);
            this.configuration = configuration;
        }

        public String getId() {
            return this.id;
        }

        public String getPhase() {
            return this.phase;
        }

        public List<String> getGoals() {
            return this.goals;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }

    public static final class Setting {
        private final String name;
        private final Object value;

        private Setting(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class ExecutionBuilder {
        private final String id;
        private String phase;
        private final List<String> goals = new ArrayList<String>();
        private ConfigurationBuilder configurationCustomization = null;

        public ExecutionBuilder(String id) {
            this.id = id;
        }

        Execution build() {
            return new Execution(this.id, this.phase, this.goals, this.configurationCustomization == null ? null : this.configurationCustomization.build());
        }

        public ExecutionBuilder phase(String phase) {
            this.phase = phase;
            return this;
        }

        public ExecutionBuilder goal(String goal) {
            this.goals.add(goal);
            return this;
        }

        public ExecutionBuilder configuration(Consumer<ConfigurationBuilder> configuration) {
            if (this.configurationCustomization == null) {
                this.configurationCustomization = new ConfigurationBuilder();
            }
            configuration.accept(this.configurationCustomization);
            return this;
        }
    }
}

