/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.condition;

import io.spring.initializr.generator.condition.ConditionalOnLanguage;
import io.spring.initializr.generator.condition.ProjectGenerationCondition;
import io.spring.initializr.generator.language.Language;
import io.spring.initializr.generator.project.ProjectDescription;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnLanguageCondition
extends ProjectGenerationCondition {
    OnLanguageCondition() {
    }

    @Override
    protected boolean matches(ProjectDescription description, ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (description.getLanguage() == null) {
            return false;
        }
        String languageId = (String)metadata.getAllAnnotationAttributes(ConditionalOnLanguage.class.getName()).getFirst((Object)"value");
        Language language = Language.forId(languageId, null);
        return description.getLanguage().id().equals(language.id());
    }
}

