/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.wordnik.swagger.models.Info;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Component
public class ServiceModelToSwagger2MapperImpl
extends ServiceModelToSwagger2Mapper {
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private ParameterMapper parameterMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private LicenseMapper licenseMapper;

    @Override
    public Swagger mapDocumentation(Documentation from) {
        if (from == null) {
            return null;
        }
        Swagger swagger = new Swagger();
        swagger.setPaths(this.mapApiListings(from.getApiListings()));
        swagger.setSchemes(this.mapSchemes(from.getSchemes()));
        swagger.setDefinitions(this.modelMapper.modelsFromApiListings(from.getApiListings()));
        swagger.setSecurityDefinitions(this.securityMapper.toSecuritySchemeDefinitions(from.getResourceListing()));
        swagger.setInfo(this.mapApiInfo(this.fromResourceListingInfo(from)));
        swagger.setTags(this.tagSetToTagList(from.getTags()));
        if (from.getConsumes() != null) {
            swagger.setConsumes(new ArrayList(from.getConsumes()));
        }
        swagger.setBasePath(from.getBasePath());
        if (from.getProduces() != null) {
            swagger.setProduces(new ArrayList(from.getProduces()));
        }
        return swagger;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        if (from == null) {
            return null;
        }
        Info info_ = new Info();
        info_.setTermsOfService(from.getTermsOfServiceUrl());
        info_.setLicense(this.licenseMapper.apiInfoToLicense(from));
        info_.setContact(this.mapContact(from.getContact()));
        info_.setTitle(from.getTitle());
        info_.setDescription(from.getDescription());
        info_.setVersion(from.getVersion());
        return info_;
    }

    @Override
    protected com.wordnik.swagger.models.Operation mapOperation(Operation from) {
        if (from == null) {
            return null;
        }
        com.wordnik.swagger.models.Operation operation = new com.wordnik.swagger.models.Operation();
        operation.setSchemes(this.stringSetToSchemeList(from.getProtocol()));
        operation.setDescription(from.getNotes());
        operation.setSecurity(this.mapAuthorizations(from.getSecurityReferences()));
        operation.setResponses(this.mapResponseMessages(from.getResponseMessages()));
        operation.setOperationId(from.getUniqueId());
        operation.setSummary(from.getSummary());
        if (from.getTags() != null) {
            operation.setTags(new ArrayList(from.getTags()));
        }
        if (from.getDeprecated() != null) {
            operation.setDeprecated(Boolean.valueOf(Boolean.parseBoolean(from.getDeprecated())));
        }
        if (from.getConsumes() != null) {
            operation.setConsumes(new ArrayList(from.getConsumes()));
        }
        if (from.getProduces() != null) {
            operation.setProduces(new ArrayList(from.getProduces()));
        }
        operation.setParameters(this.parameterListToParameterList(from.getParameters()));
        return operation;
    }

    @Override
    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if (from == null) {
            return null;
        }
        Tag tag_ = new Tag();
        tag_.setDescription(from.getDescription());
        tag_.setName(from.getName());
        return tag_;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if (documentation == null) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if (resourceListing == null) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (springfox.documentation.service.Tag tag : set) {
            list.add(this.mapTag(tag));
        }
        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Scheme> list = new ArrayList<Scheme>();
        for (String string : set) {
            list.add(Enum.valueOf(Scheme.class, string));
        }
        return list;
    }

    protected List<com.wordnik.swagger.models.parameters.Parameter> parameterListToParameterList(List<Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<com.wordnik.swagger.models.parameters.Parameter> list_ = new ArrayList<com.wordnik.swagger.models.parameters.Parameter>();
        for (Parameter parameter : list) {
            list_.add(this.parameterMapper.mapParameter(parameter));
        }
        return list_;
    }
}

