/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.utils;

import io.sundr.SundrException;
import io.sundr.builder.Constants;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.ExternalBuildables;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuildableRepository;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.functions.ClassToJavaType;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderUtils {
    public static final String BUILDABLE = "BUILDABLE";

    public static JavaMethod findBuildableConstructor(JavaClazz clazz) {
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (!candidate.getAnnotations().contains(Constants.BUILDABLE_ANNOTATION)) continue;
            return candidate;
        }
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (candidate.getArguments().length == 0) continue;
            return candidate;
        }
        return (JavaMethod)clazz.getConstructors().iterator().next();
    }

    public static JavaMethod findGetter(JavaClazz clazz, JavaProperty property) {
        for (JavaMethod method : clazz.getMethods()) {
            if (!BuilderUtils.isApplicableGetterOf(method, property)) continue;
            return method;
        }
        throw new SundrException("No getter found for property: " + property.getName() + " on class: " + clazz.getType().getFullyQualifiedName());
    }

    private static boolean isApplicableGetterOf(JavaMethod method, JavaProperty property) {
        if (!method.getReturnType().isAssignable(property.getType())) {
            return false;
        }
        if (method.getName().endsWith("get" + property.getNameCapitalized())) {
            return true;
        }
        return method.getName().endsWith("is" + property.getNameCapitalized());
    }

    public static boolean hasDefaultConstructor(JavaClazz item) {
        if (item == null) {
            return false;
        }
        if (item.getConstructors().isEmpty()) {
            return true;
        }
        for (JavaMethod constructor : item.getConstructors()) {
            if (constructor.getArguments().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildable(AttributeSupport item) {
        if (item == null) {
            return false;
        }
        if (item.getAttributes().containsKey(BUILDABLE)) {
            return (Boolean)item.getAttributes().get(BUILDABLE);
        }
        return false;
    }

    public static Set<JavaProperty> getPropertyBuildableAncestors(JavaProperty property) {
        LinkedHashSet<JavaProperty> result = new LinkedHashSet<JavaProperty>();
        JavaType baseType = property.getType();
        if (baseType.isCollection()) {
            JavaType candidate = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(baseType);
            for (JavaType descendant : BuilderUtils.getBuildableDescendants(candidate)) {
                EditableJavaType collectionType = ((JavaTypeBuilder)new JavaTypeBuilder(baseType).withGenericTypes(new JavaType[]{descendant})).build();
                String propertyName = StringUtils.deCaptializeFirst((String)descendant.getSimpleName()) + property.getNameCapitalized();
                result.add((JavaProperty)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName(propertyName)).withType((JavaType)collectionType)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes(BUILDABLE, (Object)true)).build());
            }
        } else {
            for (JavaType descendant : BuilderUtils.getBuildableDescendants(baseType)) {
                String propertyName = descendant.getSimpleName() + property.getNameCapitalized();
                result.add((JavaProperty)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName(propertyName)).withType(descendant)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes(BUILDABLE, (Object)true)).build());
            }
        }
        return result;
    }

    public static Set<JavaType> getBuildableDescendants(JavaType item) {
        if (item.getFullyQualifiedName().equals(Constants.OBJECT.getFullyQualifiedName())) {
            return new LinkedHashSet<JavaType>();
        }
        LinkedHashSet<JavaType> result = new LinkedHashSet<JavaType>();
        BuilderContext ctx = BuilderContextManager.getContext();
        BuildableRepository repository = ctx.getRepository();
        for (TypeElement element : repository.getBuildables()) {
            JavaType type = (JavaType)ctx.getStringJavaTypeFunction().apply((Object)element.toString());
            if (!BuilderUtils.isDescendant(type, item)) continue;
            result.add(type);
        }
        return result;
    }

    public static boolean hasBuildableDescendants(JavaType item) {
        if (item.getFullyQualifiedName().equals(Constants.OBJECT.getFullyQualifiedName())) {
            return false;
        }
        BuilderContext ctx = BuilderContextManager.getContext();
        BuildableRepository repository = ctx.getRepository();
        for (TypeElement element : repository.getBuildables()) {
            JavaType type = (JavaType)ctx.getStringJavaTypeFunction().apply((Object)element.toString());
            if (!BuilderUtils.isDescendant(type, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescendant(JavaType item, JavaType candidate) {
        if (item == null || candidate == null) {
            return false;
        }
        if (item.getFullyQualifiedName().equals(candidate.getFullyQualifiedName())) {
            return true;
        }
        if (BuilderUtils.isDescendant(item.getSuperClass(), candidate)) {
            return true;
        }
        for (JavaType interfaceType : item.getInterfaces()) {
            if (!BuilderUtils.isDescendant(interfaceType, candidate)) continue;
            return true;
        }
        return false;
    }

    public static Set<JavaMethod> getInlineableConstructors(JavaProperty property) {
        HashSet<JavaMethod> result = new HashSet<JavaMethod>();
        JavaClazz clazz = (JavaClazz)PropertyAs.CLASS.apply((Object)property);
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (!BuilderUtils.isInlineable(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public static boolean isInlineable(JavaMethod method) {
        if (method.getArguments().length == 0 || method.getArguments().length > 5) {
            return false;
        }
        for (JavaProperty argument : method.getArguments()) {
            if (StringUtils.isNullOrEmpty((String)argument.getType().getPackageName()) || argument.getType().getPackageName().startsWith("java.lang")) continue;
            return false;
        }
        return true;
    }

    public static JavaType getInlineType(BuilderContext context, Inline inline) {
        try {
            return ClassToJavaType.FUNCTION.apply(inline.type());
        }
        catch (MirroredTypeException e) {
            return (JavaType)context.getStringJavaTypeFunction().apply((Object)e.getTypeMirror().toString());
        }
    }

    public static JavaType getInlineReturnType(BuilderContext context, Inline inline) {
        try {
            return ClassToJavaType.FUNCTION.apply(inline.returnType());
        }
        catch (MirroredTypeException e) {
            return (JavaType)context.getStringJavaTypeFunction().apply((Object)e.getTypeMirror().toString());
        }
    }

    public static Set<TypeElement> getBuildableReferences(BuilderContext context, Buildable buildable) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        for (BuildableReference ref : buildable.refs()) {
            try {
                result.add(context.getElements().getTypeElement(ref.value().getCanonicalName()));
            }
            catch (MirroredTypeException e) {
                result.add(context.getElements().getTypeElement(e.getTypeMirror().toString()));
            }
        }
        return result;
    }

    public static Set<TypeElement> getBuildableReferences(BuilderContext context, ExternalBuildables buildable) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        for (BuildableReference ref : buildable.refs()) {
            try {
                result.add(context.getElements().getTypeElement(ref.value().getCanonicalName()));
            }
            catch (MirroredTypeException e) {
                result.add(context.getElements().getTypeElement(e.getTypeMirror().toString()));
            }
        }
        return result;
    }

    public static boolean isPrimitive(JavaType type) {
        for (JavaType t : Constants.PRIMITIVE_TYPES) {
            if (!type.getSimpleName().equals(t.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMap(JavaType type) {
        if (TypeUtils.unwrapGeneric((JavaType)type).equals((Object)TypeUtils.unwrapGeneric((JavaType)Constants.MAP))) {
            return true;
        }
        for (JavaType i : type.getInterfaces()) {
            if (type.getFullyQualifiedName().equals(i.getFullyQualifiedName()) || !BuilderUtils.isMap(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isList(JavaType type) {
        if (TypeUtils.unwrapGeneric((JavaType)type).equals((Object)TypeUtils.unwrapGeneric((JavaType)Constants.LIST))) {
            return true;
        }
        for (JavaType i : type.getInterfaces()) {
            if (type.getFullyQualifiedName().equals(i.getFullyQualifiedName()) || !BuilderUtils.isList(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSet(JavaType type) {
        if (TypeUtils.unwrapGeneric((JavaType)type).equals((Object)TypeUtils.unwrapGeneric((JavaType)Constants.SET))) {
            return true;
        }
        for (JavaType i : type.getInterfaces()) {
            if (type.getFullyQualifiedName().equals(i.getFullyQualifiedName()) || !BuilderUtils.isSet(i)) continue;
            return true;
        }
        return false;
    }
}

