/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.servlet.listing;

import io.swagger.config.Scanner;
import io.swagger.config.SwaggerConfig;
import io.swagger.models.Swagger;
import io.swagger.servlet.Reader;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiDeclarationServlet
extends HttpServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        Scanner scanner = (Scanner)servletContext.getAttribute("scanner");
        if (scanner != null) {
            Set classes;
            SwaggerConfig configurator;
            Swagger swagger = (Swagger)servletContext.getAttribute("swagger");
            if (swagger == null) {
                swagger = new Swagger();
            }
            if ((configurator = (SwaggerConfig)servletContext.getAttribute("reader")) != null) {
                configurator.configure(swagger);
            }
            if ((classes = scanner.classes()) != null) {
                Reader.read(swagger, classes);
            }
            servletContext.setAttribute("swagger", (Object)swagger);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Swagger swagger = (Swagger)this.getServletContext().getAttribute("swagger");
        if (swagger == null) {
            response.setStatus(404);
            return;
        }
        String pathInfo = request.getPathInfo();
        if ("/swagger.json".equals(pathInfo)) {
            response.getWriter().println(Json.mapper().writeValueAsString((Object)swagger));
        } else if ("/swagger.yaml".equals(pathInfo)) {
            response.getWriter().println(Yaml.mapper().writeValueAsString((Object)swagger));
        } else {
            response.setStatus(404);
        }
    }
}

