/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.dto;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.constgen.DtoField;
import io.tesler.core.dto.mapper.DtoConstructor;
import io.tesler.core.dto.mapper.ValueSupplier;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.Department;
import io.tesler.model.workflow.entity.Workflow;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.source.dto.WorkflowDto;
import io.tesler.source.dto.WorkflowDto_;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class WorkflowDtoConstructor
extends DtoConstructor<Workflow, WorkflowDto> {
    public WorkflowDtoConstructor() {
        super(Workflow.class, WorkflowDto.class);
    }

    public Map<DtoField<? super WorkflowDto, ?>, ValueSupplier<? super Workflow, ? super WorkflowDto, ?>> buildValueSuppliers() {
        return ImmutableMap.builder().put(WorkflowDto_.name, (mapping, entity) -> entity.getName()).put(WorkflowDto_.description, (mapping, entity) -> entity.getDescription()).put(WorkflowDto_.taskTypeCd, (mapping, entity) -> DictionaryType.TASK_TYPE.lookupValue(entity.getTaskTypeCd())).put(WorkflowDto_.deptShortName, (mapping, entity) -> Optional.ofNullable(entity.getDepartment()).map(Department::getShortName).orElse(null)).put(WorkflowDto_.activeVersionId, (mapping, entity) -> Optional.ofNullable(entity.getActiveVersion()).map(BaseEntity::getId).orElse(null)).put(WorkflowDto_.activeVersion, (mapping, entity) -> Optional.ofNullable(entity.getActiveVersion()).map(WorkflowVersion::getVersion).map(Objects::toString).orElse(null)).build();
    }
}

