/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.dto;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.constgen.DtoField;
import io.tesler.core.dto.mapper.DtoConstructor;
import io.tesler.core.dto.mapper.ValueSupplier;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.source.dto.WorkflowStepDto;
import io.tesler.source.dto.WorkflowStepDto_;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class WorkflowStepDtoConstructor
extends DtoConstructor<WorkflowStep, WorkflowStepDto> {
    public WorkflowStepDtoConstructor() {
        super(WorkflowStep.class, WorkflowStepDto.class);
    }

    protected Map<DtoField<? super WorkflowStepDto, ?>, ValueSupplier<? super WorkflowStep, ? super WorkflowStepDto, ?>> buildValueSuppliers() {
        return ImmutableMap.builder().put(WorkflowStepDto_.name, (mapping, entity) -> entity.getName()).put(WorkflowStepDto_.linkedStatusKey, (mapping, entity) -> Optional.ofNullable(entity.getLinkedStatusCd()).map(LOV::getKey).orElse(null)).put(WorkflowStepDto_.linkedStatusValue, (mapping, entity) -> DictionaryType.TASK_STATUS.lookupValue(entity.getLinkedStatusCd())).put(WorkflowStepDto_.workflowVersion, (mapping, entity) -> entity.getWorkflowVersion().getVersion()).put(WorkflowStepDto_.workflowName, (mapping, entity) -> entity.getWorkflowVersion().getWorkflow().getName()).put(WorkflowStepDto_.overdueTransitionId, (mapping, entity) -> Optional.ofNullable(entity.getOverdueTransition()).map(BaseEntity::getId).orElse(null)).put(WorkflowStepDto_.overdueTransitionName, (mapping, entity) -> Optional.ofNullable(entity.getOverdueTransition()).map(WorkflowTransition::getName).orElse(null)).build();
    }
}

