/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.dict.WorkflowDictionaryType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.core.service.rowmeta.FieldMetaBuilder;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowCondition;
import io.tesler.model.workflow.entity.WorkflowCondition_;
import io.tesler.model.workflow.entity.WorkflowStepConditionGroup;
import io.tesler.model.workflow.entity.WorkflowStepConditionGroup_;
import io.tesler.model.workflow.entity.WorkflowStepField;
import io.tesler.model.workflow.entity.WorkflowStepField_;
import io.tesler.model.workflow.entity.WorkflowTaskChildBcAvailability;
import io.tesler.model.workflow.entity.WorkflowTaskChildBcAvailability_;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup_;
import io.tesler.source.dto.WorkflowConditionDto;
import io.tesler.source.dto.WorkflowConditionDto_;
import java.io.Serializable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseWorkflowConditionServiceImpl<D extends WorkflowConditionDto, E extends WorkflowCondition>
extends VersionAwareResponseService<D, E> {
    public BaseWorkflowConditionServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected Specification<E> getParentSpecification(BusinessComponent bc) {
        Long parentId = bc.getParentIdAsLong();
        if (WorkflowServiceAssociation.wfStepCondRecommendedAssignee.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.stepConditionGroup).get(WorkflowStepConditionGroup_.id), (Object)parentId);
        }
        if (WorkflowServiceAssociation.wfStepFieldCond.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.stepField).get(WorkflowStepField_.id), (Object)parentId);
        }
        if (WorkflowServiceAssociation.wfChildBcAvailabilityCond.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.wfChildBcAvailability).get(WorkflowTaskChildBcAvailability_.id), (Object)parentId);
        }
        if (WorkflowServiceAssociation.wfTranCondValid.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTransitionCond.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfPostFuncGroupCond.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.transitionConditionGroup).get(WorkflowTransitionConditionGroup_.id), (Object)parentId);
        }
        return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]);
    }

    protected final CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfStepCondRecommendedAssignee.isBc((BcIdentifier)bc)) {
            entity.setStepConditionGroup((WorkflowStepConditionGroup)this.baseDAO.findById(WorkflowStepConditionGroup.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.STEP_CONDITION);
        } else if (WorkflowServiceAssociation.wfStepFieldCond.isBc((BcIdentifier)bc)) {
            entity.setStepField((WorkflowStepField)this.baseDAO.findById(WorkflowStepField.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.STEP_FIELD_CONDITION);
        } else if (WorkflowServiceAssociation.wfChildBcAvailabilityCond.isBc((BcIdentifier)bc)) {
            entity.setWfChildBcAvailability((WorkflowTaskChildBcAvailability)this.baseDAO.findById(WorkflowTaskChildBcAvailability.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.CHILD_BC_CONDITION);
        } else if (WorkflowServiceAssociation.wfTranCondValid.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfTransitionCond.isBc((BcIdentifier)bc) || WorkflowServiceAssociation.wfPostFuncGroupCond.isBc((BcIdentifier)bc)) {
            entity.setTransitionConditionGroup((WorkflowTransitionConditionGroup)this.baseDAO.findById(WorkflowTransitionConditionGroup.class, bc.getParentIdAsLong()));
            entity.setCondLinkType(CoreDictionaries.WorkflowConditionType.TRANSITION_CONDITION);
        }
        entity.setCondCd(WorkflowDictionaries.WfCondition.ALWAYS_HIDDEN);
        this.baseDAO.save(entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected abstract E create(BusinessComponent var1);

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D dto, BusinessComponent bc) {
        this.update(entity, dto, bc);
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected void update(E entity, D dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowConditionDto_.seq)) {
            entity.setSeq(((WorkflowConditionDto)((Object)dto)).getSeq());
        }
        if (dto.isFieldChanged(WorkflowConditionDto_.condCd)) {
            entity.setCondCd(WorkflowDictionaryType.WF_COND.lookupName(((WorkflowConditionDto)((Object)dto)).getCondCd()));
        }
        if (dto.isFieldChanged(WorkflowConditionDto_.dmn)) {
            entity.setDmn(((WorkflowConditionDto)((Object)dto)).getDmn());
        }
    }

    public Actions<D> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

