/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.spi.cluster.jgroups.impl.CacheManager;
import io.vertx.spi.cluster.jgroups.impl.domain.ClusteredCounterImpl;
import io.vertx.spi.cluster.jgroups.impl.domain.ClusteredLockImpl;
import io.vertx.spi.cluster.jgroups.impl.listeners.TopologyListener;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.blocks.atomic.CounterService;
import org.jgroups.blocks.locking.LockService;

public class JGroupsClusterManager
implements ClusterManager,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsClusterManager.class);
    public static final String DEFAULT_CONFIG_FILE = "default-jgroups.xml";
    public static final String CONFIG_FILE = "jgroups.xml";
    public static final String CLUSTER_NAME = "JGROUPS_CLUSTER";
    private Vertx vertx;
    private CacheManager cacheManager;
    private JChannel channel;
    private CounterService counterService;
    private LockService lockService;
    private final String lock = "Lock";
    private boolean active = false;
    private String address;
    private TopologyListener topologyListener;
    private final boolean customChannel;

    public JGroupsClusterManager() {
        this.customChannel = false;
    }

    public JGroupsClusterManager(JChannel channel) {
        this.channel = channel;
        this.customChannel = true;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> handler) {
        this.logTrace(() -> String.format("Create new AsyncMultiMap [%s] on address [%s]", name, this.address));
        this.vertx.executeBlocking(future -> {
            this.checkCluster();
            AsyncMultiMap map = this.cacheManager.createAsyncMultiMap(name);
            future.complete(map);
        }, handler);
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> handler) {
        this.logTrace(() -> String.format("Create new AsyncMap [%s] on address [%s]", name, this.address));
        this.vertx.executeBlocking(future -> {
            this.checkCluster();
            AsyncMap map = this.cacheManager.createAsyncMap(name);
            future.complete(map);
        }, handler);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        this.logTrace(() -> String.format("Create new SyncMap [%s] on address [%s]", name, this.address));
        this.checkCluster();
        return this.cacheManager.createSyncMap(name);
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> handler) {
        this.logTrace(() -> String.format("Create new Lock [%s] on address [%s]", name, this.address));
        this.checkCluster();
        this.vertx.executeBlocking(future -> {
            ClusteredLockImpl lock = new ClusteredLockImpl(this.lockService, name);
            if (lock.acquire(timeout)) {
                this.logDebug(() -> String.format("Lock acquired on [%s]", name));
                future.complete((Object)lock);
            } else {
                future.fail(String.format("Timed out waiting to get lock [%s]", name));
            }
        }, handler);
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> handler) {
        this.logTrace(() -> String.format("Create new counter [%s] on address [%s]", name, this.address));
        this.checkCluster();
        this.vertx.executeBlocking(future -> future.complete((Object)new ClusteredCounterImpl(this.vertx, this.counterService.getOrCreateCounter(name, 0L))), handler);
    }

    public String getNodeID() {
        return this.address;
    }

    public List<String> getNodes() {
        this.logTrace(() -> String.format("GetNodes on address [%s] with channel view [%s]", this.address, this.channel.getViewAsString()));
        return this.topologyListener.getNodes();
    }

    public void nodeListener(NodeListener listener) {
        this.logTrace(() -> String.format("Set nodeListener [%s] on address [%s]", listener, this.address));
        this.topologyListener.setNodeListener(listener);
    }

    public void join(Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> {
            String string = "Lock";
            synchronized ("Lock") {
                if (!this.active) {
                    try {
                        if (!this.customChannel) {
                            InputStream stream = JGroupsClusterManager.getConfigStream();
                            this.channel = new JChannel(stream);
                            stream.close();
                        }
                        this.topologyListener = new TopologyListener(this.vertx);
                        this.channel.setReceiver((Receiver)this.topologyListener);
                        this.channel.connect(CLUSTER_NAME);
                        this.address = this.channel.getAddressAsString();
                        this.logInfo(() -> String.format("Node id [%s] join the cluster", this.getNodeID()));
                        this.counterService = new CounterService((Channel)this.channel);
                        this.lockService = new LockService((Channel)this.channel);
                        this.cacheManager = new CacheManager(this.vertx, this.channel);
                        this.cacheManager.start();
                        this.active = true;
                    }
                    catch (Exception e) {
                        future.fail((Throwable)e);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
                future.complete();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }, handler);
    }

    public void leave(Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> {
            String string = "Lock";
            synchronized ("Lock") {
                if (this.active) {
                    this.active = false;
                    this.logInfo(() -> String.format("Node id [%s] leave the cluster", this.getNodeID()));
                    if (!this.customChannel) {
                        this.channel.close();
                    }
                    this.cacheManager.stop();
                    this.cacheManager = null;
                    this.topologyListener = null;
                    this.channel = null;
                }
                future.complete();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }, handler);
    }

    public boolean isActive() {
        return this.active;
    }

    private void checkCluster() {
        if (!this.active) {
            throw new VertxException("Cluster is not active!");
        }
    }

    @Override
    public Logger log() {
        return LOG;
    }

    public static InputStream getConfigStream() {
        ClassLoader ctxClsLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        if (ctxClsLoader != null) {
            is = ctxClsLoader.getResourceAsStream(CONFIG_FILE);
        }
        if (is == null && (is = JGroupsClusterManager.class.getClassLoader().getResourceAsStream(CONFIG_FILE)) == null) {
            is = JGroupsClusterManager.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE);
        }
        return is;
    }
}

