/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.spi.cluster.jgroups.impl.services.RpcExecutorService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcServerObjDelegate;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SyncMapWrapper<K, V>
implements Map<K, V>,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SyncMapWrapper.class);
    public static final int TIMEOUT = 1000;
    private final String name;
    private final Map<K, V> map;
    private final RpcExecutorService executorService;

    public SyncMapWrapper(String name, Map<K, V> map, RpcExecutorService executorService) {
        this.name = name;
        this.map = map;
        this.executorService = executorService;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.logTrace(() -> "SyncMap.put name [" + this.name + "], k = [" + key + "], v = [" + value + "]");
        return (V)this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_PUT.method(this.name, key, value), 1000L);
    }

    @Override
    public V remove(Object key) {
        this.logTrace(() -> "SyncMap.remove name [" + this.name + "], k = [" + key + "]");
        return (V)this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_REMOVE.method(this.name, key), 1000L);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> data) {
        this.logTrace(() -> "SyncMap.putAll name [" + this.name + "], data = [" + data + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_PUTALL.method(this.name, data), 1000L);
    }

    @Override
    public void clear() {
        this.logTrace(() -> "SyncMap.clear name [" + this.name + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_CLEAR.method(this.name), 1000L);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

