/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain.async;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.jgroups.impl.services.RpcExecutorService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcServerObjDelegate;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.util.Map;

public class AsyncMapWrapper<K, V>
implements AsyncMap<K, V>,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncMapWrapper.class);
    private final String name;
    private final Map<K, V> map;
    private final RpcExecutorService executorService;

    public AsyncMapWrapper(String name, Map<K, V> map, RpcExecutorService executorService) {
        this.name = name;
        this.map = map;
        this.executorService = executorService;
    }

    public void get(K k, Handler<AsyncResult<V>> handler) {
        this.logTrace(() -> "get k = [" + k + "], handler = [" + handler + "]");
        this.executorService.runAsync(() -> this.map.get(k), handler);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> handler) {
        this.logTrace(() -> "put k = [" + k + "], v = [" + v + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_PUT.method(this.name, k, v), handler);
    }

    public void put(K k, V v, long timeout, Handler<AsyncResult<Void>> handler) {
        this.logTrace(() -> "put k = [" + k + "], v = [" + v + "], timeout = [" + timeout + "] handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_PUT.method(this.name, k, v), timeout, handler);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> handler) {
        this.logTrace(() -> "putIfAbsent k = [" + k + "], v = [" + v + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_PUTIFABSENT.method(this.name, k, v), handler);
    }

    public void putIfAbsent(K k, V v, long timeout, Handler<AsyncResult<V>> handler) {
        this.logTrace(() -> "putIfAbsent k = [" + k + "], v = [" + v + "], timeout = [" + timeout + "] handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_PUTIFABSENT.method(this.name, k, v), timeout, handler);
    }

    public void remove(K k, Handler<AsyncResult<V>> handler) {
        this.logTrace(() -> "remove k = [" + k + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_REMOVE.method(this.name, k), handler);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> handler) {
        this.logTrace(() -> "removeIfPresent k = [" + k + "], v = [" + v + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_REMOVEIFPRESENT.method(this.name, k, v), handler);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> handler) {
        this.logTrace(() -> "replace k = [" + k + "], v = [" + v + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_REPLACE.method(this.name, k, v), handler);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> handler) {
        this.logTrace(() -> "replaceIfPresent k = [" + k + "], oldValue = [" + oldValue + "], newValue = [" + newValue + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_REPLACEIFPRESENT.method(this.name, k, oldValue, newValue), handler);
    }

    public void clear(Handler<AsyncResult<Void>> handler) {
        this.logTrace(() -> "clear handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MAP_CLEAR.method(this.name), handler);
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        this.logTrace(() -> "size handler = [" + handler + "]");
        this.executorService.runAsync(this.map::size, handler);
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

