/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.services;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.spi.cluster.jgroups.impl.services.RpcMapService;
import io.vertx.spi.cluster.jgroups.impl.support.DataHolder;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class DefaultRpcMapService
implements RpcMapService,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRpcMapService.class);
    private final Map<String, Map> maps = new ConcurrentHashMap<String, Map>();

    @Override
    public <K, V> Map<K, V> mapCreate(String name) {
        this.logTrace(() -> String.format("method mapCreate name[%s]", name));
        return this.maps.computeIfAbsent(name, key -> new ConcurrentHashMap());
    }

    @Override
    public <K, V> void mapPut(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logTrace(() -> "RpcMapService.put name = [" + name + "], k = [" + k + "], v = [" + v + "]");
        this.execute(name, map -> map.put(k.unwrap(), v.unwrap()));
    }

    @Override
    public <K, V> DataHolder<V> mapPutIfAbsent(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logTrace(() -> "RpcMapService.putIfAbsent name = [" + name + "], k = [" + k + "], v = [" + v + "]");
        return this.executeAndReturn(name, map -> DataHolder.wrap(map.putIfAbsent(k.unwrap(), v.unwrap())));
    }

    @Override
    public <K, V> DataHolder<V> mapRemove(String name, DataHolder<K> k) {
        this.logTrace(() -> "RpcMapService.remove name = [" + name + "], k = [" + k + "]");
        return this.executeAndReturn(name, map -> DataHolder.wrap(map.remove(k.unwrap())));
    }

    @Override
    public <K, V> boolean mapRemoveIfPresent(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logTrace(() -> "RpcMapService.removeIfPresent name = [" + name + "], k = [" + k + "], v = [" + v + "]");
        return this.executeAndReturn(name, map -> map.remove(k.unwrap(), v.unwrap()));
    }

    @Override
    public <K, V> DataHolder<V> mapReplace(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logTrace(() -> "RpcMapService.replace name = [" + name + "], k = [" + k + "], v = [" + v + "]");
        return this.executeAndReturn(name, map -> DataHolder.wrap(map.replace(k.unwrap(), v.unwrap())));
    }

    @Override
    public <K, V> boolean mapReplaceIfPresent(String name, DataHolder<K> k, DataHolder<V> oldValue, DataHolder<V> newValue) {
        this.logTrace(() -> "RpcMapService.removeIfPresent name = [" + name + "], k = [" + k + "], oldValue = [" + oldValue + "], newValue = [" + newValue + "]");
        return this.executeAndReturn(name, map -> map.replace(k.unwrap(), oldValue.unwrap(), newValue.unwrap()));
    }

    @Override
    public <K, V> void mapClear(String name) {
        this.logTrace(() -> "RpcMapService.clear name = [" + name + "]");
        this.execute(name, Map::clear);
    }

    @Override
    public <K, V> void mapPutAll(String name, Map<DataHolder<K>, DataHolder<V>> m) {
        this.logTrace(() -> "RpcMapService.mapPutAll name = [" + name + "]");
        this.execute(name, map -> m.forEach((k, v) -> map.put(k.unwrap(), v.unwrap())));
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(output);){
            oos.writeObject(this.maps);
            oos.flush();
        }
    }

    @Override
    public void readFrom(InputStream input) throws IOException, ClassNotFoundException {
        try (ObjectInputStream oos = new ObjectInputStream(input);){
            Map m = (Map)oos.readObject();
            this.maps.putAll(m);
        }
    }

    private <K, V, R> R executeAndReturn(String name, Function<Map<K, V>, R> function) {
        return function.apply(this.maps.computeIfAbsent(name, k -> new ConcurrentHashMap()));
    }

    private <K, V> void execute(String name, Consumer<Map<K, V>> consumer) {
        this.executeAndReturn(name, map -> {
            consumer.accept((Map)map);
            return null;
        });
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

