/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.test.redis.RedisFailoverClientTestBase;
import java.net.InetAddress;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class RedisFailoverClientTest
extends RedisFailoverClientTestBase {
    public void setUp() throws Exception {
        super.setUp();
        host = InetAddress.getLocalHost().getHostAddress();
        RedisOptions ro = new RedisOptions();
        for (int i = 0; i < 3; ++i) {
            ro.addSentinel(String.format("%s:%d", host, DEFAULT_SENTINEL_PORT + i));
        }
        ro.setMasterName("mymaster");
        this.redis = RedisClient.create((Vertx)this.vertx, (RedisOptions)ro);
        Thread.sleep(1000L);
    }

    @Test
    public void testInfo() {
        this.redis.info(reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertNotNull(reply0.result());
            this.testComplete();
        });
        this.await();
    }

    public void tearDown() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.redis.close(asyncResult -> latch.countDown());
        this.awaitLatch(latch);
        super.tearDown();
    }
}

