/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.redis.RedisClient;
import io.vertx.test.redis.AbstractRedisSentinelBase;
import java.net.InetAddress;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import redis.embedded.RedisSentinel;
import redis.embedded.RedisServer;

public abstract class RedisFailoverClientTestBase
extends AbstractRedisSentinelBase {
    protected RedisClient redis;

    @BeforeClass
    public static void startRedis() throws Exception {
        host = InetAddress.getLocalHost().getHostAddress();
        RedisFailoverClientTestBase.createRedisInstance(DEFAULT_PORT, new String[0]);
        ((RedisServer)instances.get(DEFAULT_PORT)).start();
        RedisFailoverClientTestBase.createSlaveRedisInstance(DEFAULT_PORT + 1, DEFAULT_PORT, new String[0]);
        ((RedisServer)instances.get(DEFAULT_PORT + 1)).start();
        for (int i = 0; i < 3; ++i) {
            RedisFailoverClientTestBase.createRedisSentinelInstance(DEFAULT_SENTINEL_PORT + i, DEFAULT_PORT);
            ((RedisSentinel)sentinels.get(DEFAULT_SENTINEL_PORT + i)).start();
        }
    }

    @AfterClass
    public static void stopRedis() throws Exception {
        for (Map.Entry entry : sentinels.entrySet()) {
            if (entry == null) continue;
            ((RedisSentinel)entry.getValue()).stop();
        }
        for (Map.Entry entry : instances.entrySet()) {
            if (entry == null) continue;
            ((RedisServer)entry.getValue()).stop();
        }
    }
}

