/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.utils.JsonUtils;
import io.vertx.test.redis.AbstractRedisSentinelBase;
import java.net.InetAddress;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import redis.embedded.RedisSentinel;
import redis.embedded.RedisServer;

public abstract class RedisSentinelClientTestBase
extends AbstractRedisSentinelBase {
    protected io.vertx.redis.sentinel.RedisSentinel redisSentinel;

    @BeforeClass
    public static void startRedis() throws Exception {
        host = InetAddress.getLocalHost().getHostAddress();
        RedisSentinelClientTestBase.createRedisInstance(DEFAULT_PORT, "loglevel debug");
        ((RedisServer)instances.get(DEFAULT_PORT)).start();
        RedisSentinelClientTestBase.createSlaveRedisInstance(DEFAULT_PORT + 1, DEFAULT_PORT, "loglevel debug");
        ((RedisServer)instances.get(DEFAULT_PORT + 1)).start();
        for (int i = 0; i < 3; ++i) {
            RedisSentinelClientTestBase.createRedisSentinelInstance(DEFAULT_SENTINEL_PORT + i, DEFAULT_PORT);
            ((RedisSentinel)sentinels.get(DEFAULT_SENTINEL_PORT + i)).start();
        }
    }

    @AfterClass
    public static void stopRedis() throws Exception {
        for (Map.Entry entry : sentinels.entrySet()) {
            if (entry == null) continue;
            ((RedisSentinel)entry.getValue()).stop();
        }
        for (Map.Entry entry : instances.entrySet()) {
            if (entry == null) continue;
            ((RedisServer)entry.getValue()).stop();
        }
    }

    protected RedisOptions getSentinelConfig() {
        RedisOptions config = new RedisOptions();
        config.setHost(host);
        config.setPort(DEFAULT_SENTINEL_PORT.intValue());
        return config;
    }

    @Test
    @Ignore
    public void testFlushConfig() {
        this.redisSentinel.flushConfig(reply -> {
            this.assertTrue(reply.succeeded());
            if (reply.succeeded()) {
                reply.result();
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testMasters() {
        this.redisSentinel.masters(reply -> {
            this.assertTrue(reply.succeeded());
            this.assertEquals(1L, ((JsonArray)reply.result()).size());
            JsonObject result = JsonUtils.convertToJsonObject((JsonArray)((JsonArray)reply.result()).getJsonArray(0));
            this.assertEquals("mymaster", result.getString("name"));
            this.assertEquals(host, result.getString("ip"));
            this.assertEquals(String.valueOf(DEFAULT_PORT), result.getString("port"));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testMaster() {
        this.redisSentinel.master("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSlaves() {
        this.redisSentinel.slaves("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSentinels() {
        this.redisSentinel.sentinels("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testMasterAddrByName() {
        this.redisSentinel.getMasterAddrByName("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testReset() {
        this.redisSentinel.reset("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    @Ignore
    public void testFailover() {
        this.redisSentinel.failover("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.assertEquals("OK", reply.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    @Ignore
    public void testCkquorum() {
        this.redisSentinel.failover("mymaster", reply -> {
            this.assertTrue(reply.succeeded());
            this.assertEquals("OK", reply.result());
            this.testComplete();
        });
        this.await();
    }
}

