/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.groovy;

import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import io.vertx.rx.java.ObservableOnSubscribeAdapter;

class HandlerAdapter<T>
extends ObservableOnSubscribeAdapter<T>
implements Handler<T> {
    private final ReadStream<T> stream;

    HandlerAdapter(ReadStream<T> stream) {
        this.stream = stream;
    }

    public void handle(T msg) {
        this.fireNext(msg);
    }

    public void onSubscribed() {
        this.stream.exceptionHandler(arg_0 -> ((HandlerAdapter)this).fireError(arg_0));
        this.stream.endHandler(v -> this.fireComplete());
        this.stream.handler((Handler)this);
    }

    public void onUnsubscribed() {
        try {
            this.stream.handler(null);
            this.stream.exceptionHandler(null);
            this.stream.endHandler(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

