/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Session;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.mongo.MongoAuth;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.shell.SSHTestBase;
import io.vertx.ext.shell.ShellService;
import io.vertx.ext.shell.ShellServiceOptions;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SSHShellTest
extends SSHTestBase {
    ShellService service;

    @Override
    @After
    public void after() throws Exception {
        if (this.service != null) {
            CountDownLatch latch = new CountDownLatch(1);
            Handler handler = ar -> latch.countDown();
            this.service.stop(handler);
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        }
        super.after();
    }

    @Override
    protected void startShell(SSHTermOptions options) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.service != null) {
            throw new IllegalStateException();
        }
        this.service = ShellService.create((Vertx)this.vertx, (ShellServiceOptions)new ShellServiceOptions().setWelcomeMessage("").setSSHOptions(options));
        CompletableFuture fut = new CompletableFuture();
        this.service.start(ar -> {
            if (ar.succeeded()) {
                fut.complete(null);
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        fut.get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testDeployServiceWithShiroAuthOptions(TestContext context) throws Exception {
        Async async = context.async();
        this.vertx.deployVerticle("service:io.vertx.ext.shell", new DeploymentOptions().setConfig(new JsonObject().put("sshOptions", new JsonObject().put("host", "localhost").put("port", Integer.valueOf(5000)).put("keyPairOptions", new JsonObject().put("path", "src/test/resources/server-keystore.jks").put("password", "wibble")).put("authOptions", new JsonObject().put("provider", "shiro").put("config", new JsonObject().put("properties_path", "classpath:test-auth.properties"))))), context.asyncAssertSuccess(v -> async.complete()));
        async.awaitSuccess(2000L);
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        channel.disconnect();
        session.disconnect();
    }

    protected static JsonObject config() {
        return new JsonObject().put("url", "jdbc:hsqldb:mem:test?shutdown=true").put("driver_class", "org.hsqldb.jdbcDriver");
    }

    @Test
    public void testDeployServiceWithJDBCAuthOptions(TestContext context) throws Exception {
        List<String> SQL = Arrays.asList("create table user (username varchar(255), password varchar(255), password_salt varchar(255) );", "create table user_roles (username varchar(255), role varchar(255));", "insert into user values ('tim', 'EC0D6302E35B7E792DF9DA4A5FE0DB3B90FCAB65A6215215771BF96D498A01DA8234769E1CE8269A105E9112F374FDAB2158E7DA58CDC1348A732351C38E12A0', 'C59EB438D1E24CACA2B1A48BC129348589D49303858E493FBE906A9158B7D5DC');");
        Connection conn = DriverManager.getConnection(SSHShellTest.config().getString("url"));
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
        Async async = context.async();
        this.vertx.deployVerticle("service:io.vertx.ext.shell", new DeploymentOptions().setConfig(new JsonObject().put("sshOptions", new JsonObject().put("host", "localhost").put("port", Integer.valueOf(5000)).put("keyPairOptions", new JsonObject().put("path", "src/test/resources/server-keystore.jks").put("password", "wibble")).put("authOptions", new JsonObject().put("provider", "jdbc").put("config", new JsonObject().put("url", "jdbc:hsqldb:mem:test?shutdown=true").put("driver_class", "org.hsqldb.jdbcDriver"))))), context.asyncAssertSuccess(v -> async.complete()));
        async.awaitSuccess(2000L);
        Session session = this.createSession("tim", "sausages", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        channel.disconnect();
        session.disconnect();
    }

    @Test
    public void testDeployServiceWithMongoAuthOptions(TestContext context) throws Exception {
        Async mongo = context.async();
        this.vertx.deployVerticle("service:io.vertx.vertx-mongo-embedded-db", context.asyncAssertSuccess(v -> mongo.complete()));
        mongo.awaitSuccess(120000L);
        JsonObject config = new JsonObject().put("connection_string", "mongodb://localhost:27018");
        MongoClient client = MongoClient.createNonShared((Vertx)this.vertx, (JsonObject)config);
        MongoAuth auth = MongoAuth.create((MongoClient)client, (JsonObject)new JsonObject());
        Async ready = context.async();
        auth.insertUser("admin", "password", Collections.emptyList(), Collections.emptyList(), context.asyncAssertSuccess(v -> ready.complete()));
        ready.awaitSuccess(2000L);
        Async async = context.async();
        this.vertx.deployVerticle("service:io.vertx.ext.shell", new DeploymentOptions().setConfig(new JsonObject().put("sshOptions", new JsonObject().put("host", "localhost").put("port", Integer.valueOf(5000)).put("keyPairOptions", new JsonObject().put("path", "src/test/resources/server-keystore.jks").put("password", "wibble")).put("authOptions", new JsonObject().put("provider", "mongo").put("config", new JsonObject().put("connection_string", "mongodb://localhost:27018"))))), context.asyncAssertSuccess(v -> async.complete()));
        async.awaitSuccess(2000L);
        Session session = this.createSession("admin", "password", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        channel.disconnect();
        session.disconnect();
    }

    @Override
    public void testExec(TestContext context) throws Exception {
        AtomicReference execCommand = new AtomicReference();
        CommandRegistry registry = CommandRegistry.getShared((Vertx)this.vertx);
        registry.registerCommand(CommandBuilder.command((String)"the-command").processHandler(process -> {
            context.assertNotNull((Object)Vertx.currentContext());
            context.assertNotNull((Object)process.session());
            execCommand.set(process.vertx());
            context.assertEquals((Object)-1, (Object)process.width());
            context.assertEquals((Object)-1, (Object)process.height());
            context.assertEquals(Arrays.asList("arg1", "arg2"), (Object)process.args());
            context.assertTrue(process.isForeground());
            StringBuilder input = new StringBuilder();
            process.stdinHandler(data -> {
                input.append((String)data);
                if (input.toString().equals("the_input")) {
                    process.end(2);
                }
            });
            process.write("the_output");
        }).build(this.vertx));
        super.testExec(context);
        Assert.assertEquals(execCommand.get(), (Object)this.vertx);
    }
}

