/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class SSHTestBase {
    protected Vertx vertx;

    @Before
    public void before() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void after() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Handler handler = ar -> latch.countDown();
        this.vertx.close(handler);
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    protected abstract void startShell(SSHTermOptions var1) throws ExecutionException, InterruptedException, TimeoutException;

    protected void startShell() throws Exception {
        this.startShell(new SSHTermOptions().setPort(5000).setHost("localhost").setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")).setAuthOptions((AuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", "classpath:test-auth.properties"))));
    }

    protected Session createSession(String username, final String password, final boolean interactive) throws Exception {
        JSch jsch = new JSch();
        Session session = jsch.getSession(username, "localhost", 5000);
        if (!interactive) {
            session.setPassword(password);
        }
        session.setUserInfo(new UserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return interactive ? password : null;
            }

            public boolean promptPassword(String s) {
                return interactive;
            }

            public boolean promptPassphrase(String s) {
                return false;
            }

            public boolean promptYesNo(String s) {
                return true;
            }

            public void showMessage(String s) {
            }
        });
        return session;
    }

    @Test
    public void testAuthenticate() throws Exception {
        this.startShell();
        for (boolean interactive : new boolean[]{false, true}) {
            Session session = this.createSession("paulo", "secret", interactive);
            session.connect();
            Channel channel = session.openChannel("shell");
            channel.connect();
            InputStream in = channel.getInputStream();
            byte[] out = new byte[2];
            Assert.assertEquals((long)2L, (long)in.read(out));
            Assert.assertEquals((Object)"% ", (Object)new String(out));
            channel.disconnect();
            session.disconnect();
        }
    }

    @Test
    public void testAuthenticationFail() throws Exception {
        this.startShell();
        for (boolean interactive : new boolean[]{false, true}) {
            Session session = this.createSession("paulo", "secret_", interactive);
            try {
                session.connect();
                Assert.fail();
            }
            catch (JSchException e) {
                String msg = e.getMessage();
                Assert.assertTrue((String)("Unexpected failure message " + msg), ("Auth cancel".equals(msg) || "Auth fail".equals(msg) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNoAuthenticationConfigured() throws Exception {
        try {
            this.startShell(new SSHTermOptions().setPort(5000).setHost("localhost").setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")));
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof VertxException));
            Assert.assertEquals((Object)"No authenticator", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testNoKeyPairConfigured() throws Exception {
        try {
            this.startShell(new SSHTermOptions().setPort(5000).setHost("localhost").setAuthOptions((AuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", "classpath:test-auth.properties"))));
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof VertxException));
            Assert.assertEquals((Object)"No key pair store configured", (Object)e.getCause().getMessage());
        }
    }

    @Test(timeout=5000L)
    public void testExec(TestContext context) throws Exception {
        int a;
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setCommand("the-command arg1 arg2");
        channel.connect();
        InputStream in = channel.getInputStream();
        StringBuilder input = new StringBuilder();
        while (!input.toString().equals("the_output") && (a = in.read()) != -1) {
            input.append((char)a);
        }
        OutputStream out = channel.getOutputStream();
        out.write("the_input".getBytes());
        out.flush();
        while (channel.isConnected()) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((long)2L, (long)channel.getExitStatus());
        session.disconnect();
    }
}

