/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.ShellServerOptions;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.support.TestCommands;
import io.vertx.ext.shell.support.TestTermServer;
import io.vertx.ext.shell.support.TestTtyConnection;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ShellCloseTest {
    Vertx vertx;
    TestCommands registry;
    TestTermServer termServer;
    ShellServer shellServer;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        this.registry = new TestCommands(this.vertx);
        this.termServer = new TestTermServer(this.vertx);
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
        this.shellServer = null;
    }

    private void startShellServer(TestContext context, long sessionTimeout, long reaperInterval) {
        if (this.shellServer != null) {
            throw new IllegalStateException("Already started");
        }
        Async latch = context.async();
        this.shellServer = ShellServer.create((Vertx)this.vertx, (ShellServerOptions)new ShellServerOptions().setSessionTimeout(sessionTimeout).setReaperInterval(reaperInterval)).registerTermServer((TermServer)this.termServer).registerCommandResolver((CommandResolver)this.registry).listen(context.asyncAssertSuccess(v -> latch.complete()));
        latch.awaitSuccess(20000L);
    }

    @Test
    public void testSessionExpires(TestContext context) throws Exception {
        Async ended = context.async();
        this.registry.add(CommandBuilder.command((String)"cmd").processHandler(process -> process.endHandler(v -> ended.complete())));
        this.startShellServer(context, 100L, 100L);
        long now = System.currentTimeMillis();
        TestTtyConnection conn = this.termServer.openConnection();
        conn.read("cmd\r");
        ended.awaitSuccess(20000L);
        context.assertTrue(conn.isClosed());
        long elapsed = System.currentTimeMillis() - now;
        context.assertTrue(elapsed < 1000L);
    }

    @Test
    public void testLastAccessed(TestContext context) throws Exception {
        this.startShellServer(context, 100L, 100L);
        TestTtyConnection conn = this.termServer.openConnection();
        for (int i = 0; i < 100; ++i) {
            conn.read("" + i);
            Thread.sleep(10L);
            context.assertFalse(conn.isClosed());
        }
        context.assertTrue(conn.getCloseLatch().await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testCloseShellServer(TestContext context) throws Exception {
        this.testClose(context, conn -> {
            Async async = context.async();
            this.shellServer.close(context.asyncAssertSuccess(v -> async.complete()));
            async.awaitSuccess(20000L);
        });
    }

    @Test
    public void testCloseConnection(TestContext context) throws Exception {
        this.testClose(context, conn -> conn.close());
        this.shellServer.close();
        this.shellServer = null;
    }

    public void testClose(TestContext context, Consumer<TestTtyConnection> closer) throws Exception {
        Async processEnded = context.async();
        Async processStarted = context.async();
        this.registry.add(CommandBuilder.command((String)"cmd").processHandler(process -> {
            process.endHandler(v -> processEnded.complete());
            processStarted.complete();
        }));
        this.startShellServer(context, 30000L, 100L);
        TestTtyConnection conn = this.termServer.openConnection();
        conn.read("cmd\r");
        processStarted.awaitSuccess(20000L);
        closer.accept(conn);
        processEnded.awaitSuccess(20000L);
        context.assertTrue(conn.getCloseLatch().await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testCloseWhileEnding(TestContext context) throws Exception {
        Async processStarted = context.async();
        Async processEnding = context.async();
        Async processEnd = context.async();
        Async closed = context.async();
        AtomicReference end = new AtomicReference();
        this.registry.add(CommandBuilder.command((String)"cmd").processHandler(process -> {
            process.endHandler(v -> {
                processEnding.complete();
                processEnd.awaitSuccess(20000L);
            });
            Context ctx = process.vertx().getOrCreateContext();
            end.set(() -> ctx.runOnContext(v -> process.end()));
            processStarted.complete();
        }));
        this.startShellServer(context, 30000L, 100L);
        TestTtyConnection conn = this.termServer.openConnection();
        conn.read("cmd\r");
        processStarted.awaitSuccess(20000L);
        ((Runnable)end.get()).run();
        processEnding.awaitSuccess(20000L);
        this.shellServer.close(context.asyncAssertSuccess(v -> closed.complete()));
        processEnd.complete();
    }
}

