/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.command.base.Sleep;
import io.vertx.ext.shell.impl.ShellImpl;
import io.vertx.ext.shell.support.TestCommands;
import io.vertx.ext.shell.support.TestTtyConnection;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.system.impl.InternalCommandManager;
import io.vertx.ext.shell.system.impl.JobImpl;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.impl.TermImpl;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ShellTest {
    Vertx vertx;
    TestCommands commands;
    ShellServer server;

    @Before
    public void before() {
        this.vertx = Vertx.vertx();
        this.commands = new TestCommands(this.vertx);
        this.server = ShellServer.create((Vertx)this.vertx).registerCommandResolver((CommandResolver)this.commands);
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    private ShellImpl createShell(TestTtyConnection conn) {
        return new ShellImpl((Term)new TermImpl(this.vertx, (TtyConnection)conn), new InternalCommandManager(new CommandResolver[]{this.commands}));
    }

    @Test
    public void testVertx(TestContext context) {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async done = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            context.assertEquals((Object)this.vertx, (Object)process.vertx());
            done.complete();
        }));
        conn.read("foo\r");
    }

    @Test
    public void testExecuteProcess(TestContext context) {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        context.assertNull((Object)shell.jobController().foregroundJob());
        context.assertEquals(Collections.emptySet(), (Object)shell.jobController().jobs());
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            context.assertEquals((Object)1, (Object)shell.jobController().jobs().size());
            Job job = shell.jobController().getJob(1);
            context.assertEquals((Object)job, (Object)shell.jobController().foregroundJob());
            context.assertEquals((Object)"foo", (Object)job.line());
            context.assertEquals((Object)ExecStatus.RUNNING, (Object)job.status());
            async.complete();
        }));
        conn.read("foo\r");
    }

    @Test
    public void testHandleReadlineBuffered(TestContext context) {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"_not_consumed").processHandler(process -> async.complete()));
        this.commands.add(CommandBuilder.command((String)"read").processHandler(process -> {
            StringBuilder buffer = new StringBuilder();
            process.stdinHandler(line -> {
                buffer.append((String)line);
                if (buffer.toString().equals("the_line")) {
                    process.end();
                }
            });
        }));
        conn.read("read\rthe_line_not_consumed\r");
    }

    @Test
    public void testExecuteReadlineBuffered(TestContext context) {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async async = context.async();
        AtomicInteger count = new AtomicInteger();
        this.commands.add(CommandBuilder.command((String)"read").processHandler(process -> {
            if (count.incrementAndGet() == 2) {
                async.complete();
            }
            process.end(0);
        }));
        conn.read("read\rread\r");
    }

    @Test
    public void testSuspendProcess(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async done = context.async();
        Async latch2 = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            Job job = shell.jobController().getJob(1);
            process.suspendHandler(v -> {
                context.assertEquals((Object)ExecStatus.STOPPED, (Object)job.status());
                context.assertNull((Object)shell.jobController().foregroundJob());
                done.complete();
            });
            latch2.complete();
        }));
        conn.read("foo\r");
        latch2.awaitSuccess(10000L);
        conn.sendEvent(TtyEvent.SUSP);
    }

    @Test
    public void testSuspendedProcessDisconnectedFromTty(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async done = context.async();
        Async latch1 = context.async();
        Async latch2 = context.async();
        Async latch3 = context.async();
        this.commands.add(CommandBuilder.command((String)"read").processHandler(process -> {
            process.stdinHandler(line -> context.fail("Should not process line " + line));
            process.suspendHandler(v -> {
                try {
                    process.write("");
                    context.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                latch2.countDown();
            });
            latch1.countDown();
        }));
        this.commands.add(CommandBuilder.command((String)"wait").processHandler(process -> {
            latch3.countDown();
            process.suspendHandler(v -> process.end(0));
        }));
        this.commands.add(CommandBuilder.command((String)"end").processHandler(process -> done.complete()));
        conn.read("read\r");
        latch1.awaitSuccess(10000L);
        conn.sendEvent(TtyEvent.SUSP);
        latch2.awaitSuccess(10000L);
        conn.read("wait\r");
        latch3.awaitSuccess(10000L);
        conn.sendEvent(TtyEvent.SUSP);
        conn.read("end\r");
    }

    @Test
    public void testResumeProcessToForeground(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        CountDownLatch latch4 = new CountDownLatch(1);
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            Job job = shell.jobController().getJob(1);
            context.assertTrue(process.isForeground());
            process.suspendHandler(v -> {
                context.assertFalse(process.isForeground());
                context.assertEquals((Object)0L, (Object)latch1.getCount());
                try {
                    process.write("");
                    context.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                latch2.countDown();
            });
            process.resumeHandler(v -> {
                context.assertTrue(process.isForeground());
                context.assertEquals((Object)0L, (Object)latch2.getCount());
                context.assertEquals((Object)ExecStatus.RUNNING, (Object)job.status());
                process.write("");
                context.assertEquals((Object)job, (Object)shell.jobController().foregroundJob());
                conn.out().setLength(0);
                process.write("resumed");
                latch3.countDown();
            });
            process.stdinHandler(txt -> {
                context.assertEquals((Object)0L, (Object)latch3.getCount());
                context.assertEquals((Object)"hello", txt);
                latch4.countDown();
            });
            latch1.countDown();
        }));
        conn.read("foo\r");
        latch1.await(10L, TimeUnit.SECONDS);
        conn.sendEvent(TtyEvent.SUSP);
        latch2.await(10L, TimeUnit.SECONDS);
        conn.read("fg\r");
        latch3.await(10L, TimeUnit.SECONDS);
        conn.read("hello");
        latch4.await(10L, TimeUnit.SECONDS);
        conn.assertWritten("resumed");
    }

    @Test
    public void testResumeProcessToBackground(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async latch1 = context.async();
        Async latch2 = context.async();
        Async latch3 = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            Job job = shell.jobController().getJob(1);
            context.assertTrue(process.isForeground());
            process.suspendHandler(v -> {
                context.assertFalse(process.isForeground());
                context.assertEquals((Object)0, (Object)latch1.count());
                try {
                    process.write("");
                    context.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                latch2.countDown();
            });
            process.resumeHandler(v -> {
                context.assertFalse(process.isForeground());
                context.assertEquals((Object)0, (Object)latch2.count());
                context.assertEquals((Object)ExecStatus.RUNNING, (Object)job.status());
                process.write("");
                context.assertNull((Object)shell.jobController().foregroundJob());
                latch3.awaitSuccess(2000L);
                process.write("resumed");
            });
            process.stdinHandler(txt -> context.fail());
            latch1.countDown();
        }));
        conn.read("foo\r");
        latch1.awaitSuccess(10000L);
        conn.sendEvent(TtyEvent.SUSP);
        latch2.awaitSuccess(10000L);
        conn.out().setLength(0);
        conn.read("bg\r");
        conn.assertWritten("bg\n[1]+ Running foo\n% ");
        latch3.countDown();
        conn.assertWritten("resumed");
        conn.read("hello");
        conn.assertWritten("hello");
    }

    @Test
    public void backgroundToForeground(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async latch1 = context.async();
        Async latch2 = context.async();
        Async latch3 = context.async();
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.suspendHandler(v -> {
                context.assertFalse(process.isForeground());
                context.assertEquals((Object)1, (Object)latch2.count());
                latch2.countDown();
            });
            process.resumeHandler(v -> context.assertFalse(process.isForeground()));
            process.foregroundHandler(v -> {
                context.assertTrue(process.isForeground());
                latch3.countDown();
            });
            process.stdinHandler(line -> async.complete());
            latch1.countDown();
        }));
        conn.read("foo\r");
        latch1.awaitSuccess(2000L);
        conn.sendEvent(TtyEvent.SUSP);
        latch2.awaitSuccess(2000L);
        conn.read("bg\r");
        context.assertNull((Object)shell.jobController().foregroundJob());
        conn.read("fg\r");
        latch3.await();
        context.assertNotNull((Object)shell.jobController().foregroundJob());
        context.assertEquals((Object)shell.jobController().getJob(1), (Object)shell.jobController().foregroundJob());
        conn.read("whatever");
    }

    @Test
    public void testExecuteBufferedCommand(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl adapter = this.createShell(conn);
        adapter.init().readline();
        CountDownLatch latch = new CountDownLatch(1);
        Async done = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            context.assertEquals(null, (Object)conn.checkWritten("% foo\n"));
            conn.read("bar");
            process.end();
            latch.countDown();
        }));
        this.commands.add(CommandBuilder.command((String)"bar").processHandler(process -> {
            context.assertEquals(null, (Object)conn.checkWritten("\n"));
            done.complete();
        }));
        conn.read("foo\r");
        latch.await(10L, TimeUnit.SECONDS);
        context.assertNull((Object)conn.checkWritten("bar"));
        context.assertNull((Object)conn.checkWritten("% bar"));
        conn.read("\r");
    }

    @Test
    public void testEchoCharsDuringExecute(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            context.assertEquals(null, (Object)conn.checkWritten("% foo\n"));
            conn.read("\u0007");
            context.assertNull((Object)conn.checkWritten("^G"));
            conn.read("A");
            context.assertNull((Object)conn.checkWritten("A"));
            conn.read("\r");
            context.assertNull((Object)conn.checkWritten("\n"));
            conn.read("\u0003");
            context.assertNull((Object)conn.checkWritten("^C"));
            conn.read("\u0004");
            context.assertNull((Object)conn.checkWritten("^D"));
            async.complete();
        }));
        conn.read("foo\r");
    }

    public void testExit(TestContext context) throws Exception {
        this.commands.add(Command.create((Vertx)this.vertx, Sleep.class));
        for (String cmd : Arrays.asList("exit", "logout")) {
            TestTtyConnection conn = new TestTtyConnection(this.vertx);
            ShellImpl adapter = this.createShell(conn);
            adapter.init().readline();
            conn.read("sleep 10000\r");
            long now = System.currentTimeMillis();
            while (adapter.jobController().jobs().size() == 0 || ((JobImpl)adapter.jobController().jobs().iterator().next()).actualStatus() != ExecStatus.RUNNING) {
                context.assertTrue(System.currentTimeMillis() - now < 2000L);
                Thread.sleep(1L);
            }
            conn.sendEvent(TtyEvent.SUSP);
            conn.read("bg\r");
            conn.read(cmd + "\r");
            context.assertTrue(conn.isClosed());
            now = System.currentTimeMillis();
            while (adapter.jobController().jobs().size() > 0) {
                context.assertTrue(System.currentTimeMillis() - now < 2000L);
                Thread.sleep(10L);
            }
        }
    }

    @Test
    public void testEOF(TestContext context) throws Exception {
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        conn.read("\u0004");
        context.assertTrue(conn.getCloseLatch().await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testAbc(TestContext context) throws Exception {
        Async barLatch = context.async();
        Async endLatch = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.stdinHandler(cp -> context.fail());
            process.endHandler(v -> barLatch.complete());
            process.end();
        }).build(this.vertx));
        this.commands.add(CommandBuilder.command((String)"bar").processHandler(process -> {
            process.endHandler(v -> endLatch.complete());
            process.end();
        }).build(this.vertx));
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        conn.read("foo\r");
        barLatch.awaitSuccess(2000L);
        conn.read("bar\r");
    }

    @Test
    public void testSetStdinOnResumeToForeground(TestContext context) throws Exception {
        Async fooRunning = context.async();
        Async fooSusp = context.async();
        Async fooResumed = context.async();
        Async readLatch = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.suspendHandler(v -> fooSusp.complete());
            process.resumeHandler(v -> fooResumed.complete());
            process.stdinHandler(line -> {
                context.assertEquals((Object)"foo_msg", line);
                readLatch.complete();
            });
            fooRunning.complete();
        }));
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        conn.read("foo\r");
        fooRunning.awaitSuccess(2000L);
        conn.sendEvent(TtyEvent.SUSP);
        fooSusp.awaitSuccess(2000L);
        conn.read("fg\r");
        fooResumed.awaitSuccess(2000L);
        conn.read("foo_msg");
    }

    @Test
    public void testSetStdinOnBackgroundToForeground(TestContext context) throws Exception {
        Async fooRunning = context.async();
        Async fooSusp = context.async();
        Async fooResumed = context.async();
        Async fooToForeground = context.async();
        Async readLatch = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.suspendHandler(v -> fooSusp.complete());
            process.resumeHandler(v -> fooResumed.complete());
            process.foregroundHandler(v -> fooToForeground.complete());
            process.stdinHandler(line -> {
                context.assertEquals((Object)"foo_msg", line);
                readLatch.complete();
            });
            fooRunning.complete();
        }));
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        conn.read("foo\r");
        fooRunning.awaitSuccess(2000L);
        conn.sendEvent(TtyEvent.SUSP);
        fooSusp.awaitSuccess(2000L);
        conn.read("bg\r");
        fooResumed.awaitSuccess(2000L);
        conn.read("fg\r");
        fooToForeground.awaitSuccess(20000000L);
        conn.read("foo_msg");
    }

    @Test
    public void testEndInBackground(TestContext context) throws Exception {
        Async fooRunning = context.async();
        Async fooSusp = context.async();
        Async fooResumed = context.async();
        Async endLatch = context.async();
        AtomicReference cmdProcess = new AtomicReference();
        AtomicReference cmdContext = new AtomicReference();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            cmdProcess.set(process);
            cmdContext.set(Vertx.currentContext());
            process.suspendHandler(v -> fooSusp.complete());
            process.resumeHandler(v -> fooResumed.complete());
            process.endHandler(v -> endLatch.complete());
            fooRunning.complete();
        }));
        TestTtyConnection conn = new TestTtyConnection(this.vertx);
        ShellImpl shell = this.createShell(conn);
        shell.init().readline();
        conn.read("foo\r");
        fooRunning.awaitSuccess(2000L);
        conn.sendEvent(TtyEvent.SUSP);
        fooSusp.awaitSuccess(2000L);
        conn.read("bg\r");
        fooResumed.awaitSuccess(2000L);
        ((Context)cmdContext.get()).runOnContext(v -> ((CommandProcess)cmdProcess.get()).end());
        long now = System.currentTimeMillis();
        while (shell.jobController().jobs().size() > 0) {
            context.assertTrue(System.currentTimeMillis() - now < 2000L);
            Thread.sleep(1L);
        }
        conn.read("exit\r");
        conn.getCloseLatch().await(2L, TimeUnit.SECONDS);
    }
}

