/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.command.impl.CommandRegistryImpl;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CommandRegistryTest {
    Vertx vertx = Vertx.vertx();
    CommandRegistry registry;

    @Before
    public void before() throws Exception {
        this.vertx = Vertx.vertx();
        this.registry = CommandRegistry.getShared((Vertx)this.vertx);
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testRegister(TestContext context) {
        CommandRegistry registry = CommandRegistry.getShared((Vertx)this.vertx);
        CommandBuilder command = CommandBuilder.command((String)"hello");
        registry.registerCommand(command.build(this.vertx), context.asyncAssertSuccess(reg -> registry.unregisterCommand("hello", context.asyncAssertSuccess(done -> context.assertEquals(Collections.emptyList(), (Object)registry.commands())))));
    }

    @Test
    public void testDuplicateRegistration(TestContext context) {
        CommandRegistry registry = CommandRegistry.getShared((Vertx)this.vertx);
        Command a = CommandBuilder.command((String)"a").build(this.vertx);
        Command b = CommandBuilder.command((String)"b").build(this.vertx);
        registry.registerCommand(a, context.asyncAssertSuccess(reg -> registry.registerCommands(Arrays.asList(a, b), context.asyncAssertFailure(err -> {
            context.assertEquals((Object)1, (Object)registry.commands().size());
            context.assertNotNull((Object)registry.getCommand("a"));
        }))));
    }

    @Test
    public void testCloseRegistryOnVertxClose(TestContext context) {
        Vertx vertx = Vertx.vertx();
        CommandRegistryImpl registry = (CommandRegistryImpl)CommandRegistry.getShared((Vertx)vertx);
        context.assertFalse(registry.isClosed());
        vertx.close(context.asyncAssertSuccess(v -> context.assertTrue(registry.isClosed())));
    }

    @Test
    public void testUndeployInVerticleContext(TestContext context) {
        final CommandRegistry registry = CommandRegistry.getShared((Vertx)this.vertx);
        Async async = context.async();
        AtomicReference ref = new AtomicReference();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Future<Void> startFuture) throws Exception {
                CommandBuilder command = CommandBuilder.command((String)"hello");
                command.processHandler(process -> {});
                registry.registerCommand(command.build(this.vertx), ar -> {
                    if (ar.succeeded()) {
                        startFuture.complete();
                    } else {
                        startFuture.fail(ar.cause());
                    }
                });
            }
        }, context.asyncAssertSuccess(id -> {
            ref.set(id);
            async.complete();
        }));
        async.awaitSuccess(5000L);
        this.vertx.undeploy((String)ref.get(), context.asyncAssertSuccess(v -> context.assertEquals(Collections.emptyList(), (Object)registry.commands())));
    }

    @Test
    public void testUndeployCommands(TestContext context) throws Exception {
        Async async = context.async();
        this.registry.registerCommands(Arrays.asList(CommandBuilder.command((String)"a").build(this.vertx), CommandBuilder.command((String)"b").build(this.vertx)), context.asyncAssertSuccess(list -> async.complete()));
        async.awaitSuccess(2000L);
        HashSet afterIds = new HashSet(this.vertx.deploymentIDs());
        System.out.println(afterIds);
        context.assertEquals((Object)1, (Object)afterIds.size());
        String deploymentId = (String)afterIds.iterator().next();
        Async async2 = context.async();
        this.registry.unregisterCommand("a", context.asyncAssertSuccess(v -> async2.complete()));
        async2.awaitSuccess(2000L);
        context.assertTrue(this.vertx.deploymentIDs().contains(deploymentId));
        Async async3 = context.async();
        this.registry.unregisterCommand("b", context.asyncAssertSuccess(v -> async3.complete()));
        async3.awaitSuccess(2000L);
        context.assertFalse(this.vertx.deploymentIDs().contains(deploymentId));
    }
}

