/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.Shell;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.command.base.BaseCommandPack;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.term.Pty;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DeployVerticleTest {
    Vertx vertx;
    ShellServer server;
    static AtomicReference<Context> ctx;

    @Before
    public void before(TestContext context) throws Exception {
        ctx = new AtomicReference<Object>(null);
        this.vertx = Vertx.vertx();
        this.server = ShellServer.create((Vertx)this.vertx).registerCommandResolver((CommandResolver)new BaseCommandPack(this.vertx)).listen(context.asyncAssertSuccess());
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testDeploy(TestContext context) {
        String cmd = "verticle-deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle";
        String result = this.testDeployCmd(context, cmd);
        context.assertNotNull((Object)ctx.get());
        context.assertEquals((Object)result, (Object)("Deployed " + ctx.get().deploymentID()));
        context.assertEquals((Object)1, (Object)ctx.get().getInstanceCount());
    }

    @Test
    public void testDeployWithOptionsAsEmptyString(TestContext context) {
        String cmd = "verticle-deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle ''";
        String result = this.testDeployCmd(context, cmd);
        context.assertNotNull((Object)ctx.get());
        context.assertEquals((Object)result, (Object)("Deployed " + ctx.get().deploymentID()));
        context.assertEquals((Object)1, (Object)ctx.get().getInstanceCount());
    }

    @Test
    public void testDeployWithOptionsAsJsonInstance(TestContext context) {
        String cmd = "verticle-deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle '{\"instances\" : 8}'";
        String result = this.testDeployCmd(context, cmd);
        context.assertNotNull((Object)ctx.get());
        context.assertEquals((Object)result, (Object)("Deployed " + ctx.get().deploymentID()));
        context.assertEquals((Object)8, (Object)ctx.get().getInstanceCount());
    }

    @Test
    public void testDeployWithOptionsAsJsonConfig(TestContext context) {
        String cmd = "verticle-deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle '{\"config\":{\"ok\":true}}'";
        String result = this.testDeployCmd(context, cmd);
        context.assertNotNull((Object)ctx.get());
        context.assertEquals((Object)result, (Object)("Deployed " + ctx.get().deploymentID()));
        context.assertEquals((Object)1, (Object)ctx.get().getInstanceCount());
        context.assertNotNull((Object)ctx.get().config());
        context.assertTrue(ctx.get().config().containsKey("ok"));
        context.assertEquals((Object)true, (Object)ctx.get().config().getBoolean("ok"));
    }

    @Test
    public void testDeployWithOptionsAsEmptyJsonString(TestContext context) {
        String cmd = "verticle-deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle '{}'";
        String result = this.testDeployCmd(context, cmd);
        context.assertNotNull((Object)ctx.get());
        context.assertEquals((Object)result, (Object)("Deployed " + ctx.get().deploymentID()));
        context.assertEquals((Object)1, (Object)ctx.get().getInstanceCount());
    }

    @Test
    public void testDeployWithOptionsAsInvalidJsonString(TestContext context) {
        String cmd = "verticle-deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle '{'";
        String result = this.testDeployCmd(context, cmd);
        String msg = "Could not deploy io.vertx.ext.shell.command.base.DeployVerticleTest$SomeVerticle with deployment options";
        context.assertNull((Object)ctx.get());
        context.assertTrue(result.startsWith(msg));
    }

    private String testDeployCmd(TestContext context, String cmd) {
        Async async = context.async();
        Shell shell = this.server.createShell();
        Pty pty = Pty.create();
        StringBuffer result = new StringBuffer();
        pty.stdoutHandler(result::append);
        Job job = shell.createJob(cmd).setTty(pty.slave());
        job.statusUpdateHandler(status -> {
            if (status == ExecStatus.TERMINATED) {
                async.complete();
            }
        });
        job.run();
        async.awaitSuccess(5000L);
        shell.close();
        return result.toString().trim();
    }

    public static class SomeVerticle
    extends AbstractVerticle {
        public void start() throws Exception {
            ctx.set(this.vertx.getOrCreateContext());
        }
    }
}

