/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.support;

import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.util.Helper;
import io.termd.core.util.Vector;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class TestTtyConnection
implements TtyConnection {
    private final Context context;
    private Consumer<String> terminalTypeHandler;
    private Consumer<Vector> sizeHandler;
    private BiConsumer<TtyEvent, Integer> eventHandler;
    private Consumer<int[]> stdinHandler;
    private volatile Consumer<Void> closeHandler;
    private final StringBuilder out = new StringBuilder();
    private volatile boolean closed;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private volatile long lastAccessedTime;

    public TestTtyConnection(Vertx vertx) {
        this.context = vertx.getOrCreateContext();
    }

    public Charset inputCharset() {
        return StandardCharsets.UTF_8;
    }

    public Charset outputCharset() {
        return StandardCharsets.UTF_8;
    }

    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public String terminalType() {
        return "xterm";
    }

    public Vector size() {
        return new Vector(40, 20);
    }

    public Consumer<String> getTerminalTypeHandler() {
        return this.terminalTypeHandler;
    }

    public void setTerminalTypeHandler(Consumer<String> handler) {
        this.terminalTypeHandler = handler;
    }

    public Consumer<Vector> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Vector> handler) {
        this.sizeHandler = handler;
    }

    public BiConsumer<TtyEvent, Integer> getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(BiConsumer<TtyEvent, Integer> handler) {
        this.eventHandler = handler;
    }

    public Consumer<int[]> getStdinHandler() {
        return this.stdinHandler;
    }

    public void setStdinHandler(Consumer<int[]> consumer) {
        this.stdinHandler = consumer;
    }

    public Consumer<int[]> stdoutHandler() {
        return codePoints -> {
            TestTtyConnection testTtyConnection = this;
            synchronized (testTtyConnection) {
                Helper.appendCodePoints((int[])codePoints, (StringBuilder)this.out());
                this.notify();
            }
        };
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    public void setCloseHandler(Consumer<Void> handler) {
        this.closeHandler = handler;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.closeHandler != null) {
                this.context.runOnContext(v -> this.closeHandler.accept(null));
            }
            this.closeLatch.countDown();
        }
    }

    public void execute(Runnable task) {
        this.context.runOnContext(v -> task.run());
    }

    public void schedule(Runnable task, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public void sendEvent(TtyEvent event) {
        int c;
        switch (event) {
            case INTR: {
                c = 3;
                break;
            }
            case SUSP: {
                c = 26;
                break;
            }
            case EOF: {
                c = 4;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.context.runOnContext(v -> this.eventHandler.accept(event, c));
    }

    public void read(String s) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.context.runOnContext(v -> this.stdinHandler.accept(Helper.toCodePoints((String)s)));
    }

    public synchronized String checkWritten(String s) {
        while (true) {
            String expected;
            int l;
            String actual;
            if (!(actual = this.out.substring(0, l = Math.min(s.length(), this.out.length()))).equals(expected = s.substring(0, l))) {
                return "Was expecting <" + actual + "> to be equals to <" + expected + ">";
            }
            this.out.replace(0, l, "");
            s = s.substring(l);
            if (s.length() == 0) break;
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public synchronized void assertWritten(String s) {
        String report = this.checkWritten(s);
        if (report != null) {
            throw new AssertionError((Object)report);
        }
    }

    public StringBuilder out() {
        return this.out;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public CountDownLatch getCloseLatch() {
        return this.closeLatch;
    }
}

