/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.shell.SSHTestBase;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.shell.term.impl.SSHExec;
import io.vertx.ext.shell.term.impl.SSHServer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SSHServerTest
extends SSHTestBase {
    TermServer server;
    Handler<Term> termHandler;
    Handler<SSHExec> execHandler;
    AuthProvider authProvider;

    @Override
    public void before() {
        super.before();
        this.termHandler = term -> term.write("% ");
    }

    @Override
    @After
    public void after() throws Exception {
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(ar -> latch.countDown());
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        }
        super.after();
    }

    @Override
    protected void startShell(SSHTermOptions options) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.server != null) {
            throw new IllegalStateException();
        }
        this.server = TermServer.createSSHTermServer((Vertx)this.vertx, (SSHTermOptions)options);
        CompletableFuture fut = new CompletableFuture();
        this.server.termHandler(this.termHandler);
        ((SSHServer)this.server).setExecHandler(this.execHandler);
        this.server.authProvider(this.authProvider);
        this.server.listen(ar -> {
            if (ar.succeeded()) {
                fut.complete(null);
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        fut.get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testRead(TestContext context) throws Exception {
        Async async = context.async();
        this.termHandler = term -> term.stdinHandler(s -> {
            context.assertEquals((Object)"hello", s);
            async.complete();
        });
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        OutputStream out = channel.getOutputStream();
        out.write("hello".getBytes());
        out.flush();
        channel.disconnect();
        session.disconnect();
    }

    @Test
    public void testWrite() throws Exception {
        this.termHandler = term -> term.write("hello");
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        InputStreamReader in = new InputStreamReader(channel.getInputStream());
        int count = 5;
        StringBuilder sb = new StringBuilder();
        while (count > 0) {
            int code = ((Reader)in).read();
            if (code == -1) {
                count = 0;
                continue;
            }
            --count;
            sb.append((char)code);
        }
        Assert.assertEquals((Object)"hello", (Object)sb.toString());
        channel.disconnect();
        session.disconnect();
    }

    @Test
    public void testResizeHandler(TestContext context) throws Exception {
        Async async = context.async();
        this.termHandler = term -> term.resizehandler(v -> {
            context.assertEquals((Object)20, (Object)term.width());
            context.assertEquals((Object)10, (Object)term.height());
            async.complete();
        });
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        ChannelShell channel = (ChannelShell)session.openChannel("shell");
        channel.connect();
        OutputStream out = channel.getOutputStream();
        channel.setPtySize(20, 10, 160, 80);
        out.flush();
        channel.disconnect();
        session.disconnect();
    }

    @Test
    public void testCloseHandler(TestContext context) throws Exception {
        Async async = context.async();
        this.termHandler = term -> term.closeHandler(v -> async.complete());
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        channel.disconnect();
        session.disconnect();
    }

    @Test
    public void testClose(TestContext context) throws Exception {
        this.testClose(context, term -> this.vertx.setTimer(10L, id -> term.close()));
    }

    @Test
    public void testCloseImmediatly(TestContext context) throws Exception {
        this.testClose(context, Term::close);
    }

    private void testClose(TestContext context, Consumer<Term> closer) throws Exception {
        Async async = context.async();
        this.termHandler = term -> {
            term.closeHandler(v -> async.complete());
            closer.accept((Term)term);
        };
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        while (channel.isClosed()) {
            Thread.sleep(10L);
        }
    }

    @Test
    public void testType(TestContext context) throws Exception {
        Async async = context.async();
        this.termHandler = term -> {
            context.assertEquals((Object)"vt100", (Object)term.type());
            async.complete();
        };
        this.startShell();
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
    }

    @Test
    public void testExternalAuthProvider(TestContext context) throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.authProvider = (authInfo, resultHandler) -> {
            count.incrementAndGet();
            final String username = authInfo.getString("username");
            String password = authInfo.getString("password");
            if (username.equals("paulo") && password.equals("anothersecret")) {
                resultHandler.handle((Object)Future.succeededFuture((Object)new AbstractUser(){

                    protected void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)true));
                    }

                    public JsonObject principal() {
                        return new JsonObject().put("username", username);
                    }

                    public void setAuthProvider(AuthProvider authProvider) {
                    }
                }));
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"not authenticated"));
            }
        };
        Async async = context.async();
        this.termHandler = term -> {
            context.assertEquals((Object)1, (Object)count.get());
            async.complete();
        };
        this.startShell(new SSHTermOptions().setPort(5000).setHost("localhost").setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")));
        Session session = this.createSession("paulo", "anothersecret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
    }

    @Test
    public void testExternalAuthProviderFails(TestContext context) throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.authProvider = (authInfo, resultHandler) -> {
            count.incrementAndGet();
            resultHandler.handle((Object)Future.failedFuture((String)"not authenticated"));
        };
        this.termHandler = term -> context.fail();
        this.startShell(new SSHTermOptions().setPort(5000).setHost("localhost").setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")));
        Session session = this.createSession("paulo", "anothersecret", false);
        try {
            session.connect();
            context.fail("Was not expected to login");
        }
        catch (JSchException e) {
            Assert.assertEquals((Object)"Auth cancel", (Object)e.getMessage());
        }
        context.assertEquals((Object)1, (Object)count.get());
    }

    @Test
    public void testDifferentCharset(TestContext context) throws Exception {
        this.termHandler = term -> {
            term.write("\u20ac");
            term.close();
        };
        this.startShell(new SSHTermOptions().setDefaultCharset("ISO_8859_1").setPort(5000).setHost("localhost").setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")).setAuthOptions((AuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", "classpath:test-auth.properties"))));
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
        InputStream in = channel.getInputStream();
        int b = in.read();
        context.assertEquals((Object)63, (Object)b);
    }

    @Test
    public void testKeymapFromFilesystem() throws Exception {
        URL url = TermServer.class.getResource("/io/vertx/ext/shell/inputrc");
        File f = new File(url.toURI());
        this.termHandler = Term::close;
        this.startShell(new SSHTermOptions().setIntputrc(f.getAbsolutePath()).setPort(5000).setHost("localhost").setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")).setAuthOptions((AuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", "classpath:test-auth.properties"))));
        Session session = this.createSession("paulo", "secret", false);
        session.connect();
        Channel channel = session.openChannel("shell");
        channel.connect();
    }

    @Override
    public void testExec(TestContext context) throws Exception {
        this.execHandler = exec -> {
            context.assertNotNull((Object)Vertx.currentContext());
            context.assertEquals((Object)"the-command arg1 arg2", (Object)exec.command());
            exec.write("the_output");
            StringBuilder input = new StringBuilder();
            context.assertEquals((Object)-1, (Object)exec.width());
            context.assertEquals((Object)-1, (Object)exec.height());
            exec.stdinHandler(data -> {
                input.append((String)data);
                if (input.toString().equals("the_input")) {
                    exec.end(2);
                }
            });
        };
        super.testExec(context);
    }
}

