/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.netty.channel.EventLoopGroup;
import io.termd.core.ssh.TtyCommand;
import io.termd.core.ssh.netty.NettyIoHandlerBridge;
import io.termd.core.ssh.netty.NettyIoServiceFactoryFactory;
import io.termd.core.ssh.netty.NettyIoSession;
import io.termd.core.tty.SshTtyTestBase;
import io.termd.core.tty.TtyConnection;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.shell.term.impl.VertxIoHandlerBridge;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.server.SshServer;
import org.junit.After;
import org.junit.Before;

public class VertxSshTtyTest
extends SshTtyTestBase {
    private Vertx vertx;
    private ContextInternal context;

    @Before
    public void before() {
        super.before();
        this.vertx = Vertx.vertx();
        this.context = (ContextInternal)this.vertx.getOrCreateContext();
    }

    @After
    public void after() throws Exception {
        super.after();
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.close(v -> latch.countDown());
        this.await(latch);
    }

    protected SshServer createServer() {
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setIoServiceFactoryFactory((IoServiceFactoryFactory)new NettyIoServiceFactoryFactory((EventLoopGroup)this.context.nettyEventLoop(), (NettyIoHandlerBridge)new VertxIoHandlerBridge(this.context)));
        return sshd;
    }

    protected TtyCommand createConnection(Consumer<TtyConnection> onConnect) {
        this.assertEquals(this.context, Vertx.currentContext());
        return new TtyCommand(this.charset, onConnect){

            public void execute(Runnable task) {
                Session session = this.session.getSession();
                NettyIoSession ioSession = (NettyIoSession)session.getIoSession();
                ioSession.execute(task);
            }

            public void schedule(Runnable task, long delay, TimeUnit unit) {
                Session session = this.session.getSession();
                NettyIoSession ioSession = (NettyIoSession)session.getIoSession();
                ioSession.schedule(task, delay, unit);
            }
        };
    }

    protected void assertThreading(Thread connThread, Thread schedulerThread) throws Exception {
        this.assertTrue(connThread.getName().startsWith("vert.x-eventloop-thread"));
        this.assertEquals(connThread, schedulerThread);
        this.assertEquals(this.context, Vertx.currentContext());
    }
}

