/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TcpEventBusBridgeEventTest {
    private Vertx vertx;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        Async async = context.async();
        this.vertx.eventBus().consumer("hello", msg -> msg.reply((Object)new JsonObject().put("value", "Hello " + ((JsonObject)msg.body()).getString("value"))));
        this.vertx.eventBus().consumer("echo", msg -> msg.reply(msg.body()));
        this.vertx.setPeriodic(1000L, __ -> this.vertx.eventBus().send("ping", (Object)new JsonObject().put("value", "hi")));
        TcpEventBusBridge bridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)new BridgeOptions().addInboundPermitted(new PermittedOptions().setAddress("hello")).addInboundPermitted(new PermittedOptions().setAddress("echo")).addInboundPermitted(new PermittedOptions().setAddress("test")).addOutboundPermitted(new PermittedOptions().setAddress("echo")).addOutboundPermitted(new PermittedOptions().setAddress("ping")), (NetServerOptions)new NetServerOptions().setSsl(true).setTrustStoreOptions(new JksOptions().setPath("server.truststore").setPassword("wibble")).setKeyStoreOptions(new JksOptions().setPath("server.keystore").setPassword("wibble")), be -> {
            Logger l = LoggerFactory.getLogger((String)this.getClass().getName());
            l.info((Object)("Handled a bridge event " + be.getRawMessage()));
            if (be.socket().isSsl()) {
                try {
                    for (X509Certificate c : be.socket().peerCertificateChain()) {
                        l.info((Object)c.getSubjectDN().toString());
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    l.warn((Object)"Caught SSLPeerUnverifiedException when processing peerCertificateChain ");
                }
            }
            be.complete((Object)true);
        });
        bridge.listen(7000, res -> {
            context.assertTrue(res.succeeded());
            async.complete();
        });
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testSendVoidMessage(TestContext context) {
        NetClient client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setTrustAll(true).setKeyStoreOptions(new JksOptions().setPath("client.keystore").setPassword("wibble")));
        Async async = context.async();
        this.vertx.eventBus().consumer("test", msg -> {
            client.close();
            async.complete();
        });
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameHelper.sendFrame((String)"send", (String)"test", (JsonObject)new JsonObject().put("value", "vert.x"), (WriteStream)socket);
        });
    }
}

